/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.UnsuccessfulItem;
import software.amazon.awssdk.services.ec2.transform.UnsuccessfulItemErrorUnmarshaller;

public class UnsuccessfulItemUnmarshaller
implements Unmarshaller<UnsuccessfulItem, StaxUnmarshallerContext> {
    private static final UnsuccessfulItemUnmarshaller INSTANCE = new UnsuccessfulItemUnmarshaller();

    public UnsuccessfulItem unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        UnsuccessfulItem.Builder unsuccessfulItem = UnsuccessfulItem.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("error", targetDepth)) {
                    unsuccessfulItem.error(UnsuccessfulItemErrorUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("resourceId", targetDepth)) continue;
                unsuccessfulItem.resourceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (UnsuccessfulItem)unsuccessfulItem.build();
    }

    public static UnsuccessfulItemUnmarshaller getInstance() {
        return INSTANCE;
    }
}

