/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeRequest;

public class ModifySubnetAttributeRequestMarshaller
implements Marshaller<Request<ModifySubnetAttributeRequest>, ModifySubnetAttributeRequest> {
    public Request<ModifySubnetAttributeRequest> marshall(ModifySubnetAttributeRequest modifySubnetAttributeRequest) {
        if (modifySubnetAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)modifySubnetAttributeRequest, "EC2Client");
        request.addParameter("Action", "ModifySubnetAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifySubnetAttributeRequest.assignIpv6AddressOnCreation() != null) {
            request.addParameter("AssignIpv6AddressOnCreation.Value", StringUtils.fromBoolean((Boolean)modifySubnetAttributeRequest.assignIpv6AddressOnCreation()));
        }
        if (modifySubnetAttributeRequest.mapPublicIpOnLaunch() != null) {
            request.addParameter("MapPublicIpOnLaunch.Value", StringUtils.fromBoolean((Boolean)modifySubnetAttributeRequest.mapPublicIpOnLaunch()));
        }
        if (modifySubnetAttributeRequest.subnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString((String)modifySubnetAttributeRequest.subnetId()));
        }
        return request;
    }
}

