/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.ec2.EC2Client;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsResponse;
import software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfig;

public final class DescribeSpotFleetRequestsPaginator
implements SdkIterable<DescribeSpotFleetRequestsResponse> {
    private final EC2Client client;
    private final DescribeSpotFleetRequestsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeSpotFleetRequestsPaginator(EC2Client client, DescribeSpotFleetRequestsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeSpotFleetRequestsResponseFetcher();
    }

    public Iterator<DescribeSpotFleetRequestsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<SpotFleetRequestConfig> spotFleetRequestConfigs() {
        Function<DescribeSpotFleetRequestsResponse, Iterator> getIterator = response -> response != null ? response.spotFleetRequestConfigs().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeSpotFleetRequestsResponseFetcher
    implements NextPageFetcher<DescribeSpotFleetRequestsResponse> {
        private DescribeSpotFleetRequestsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSpotFleetRequestsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeSpotFleetRequestsResponse nextPage(DescribeSpotFleetRequestsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSpotFleetRequestsPaginator.this.client.describeSpotFleetRequests(DescribeSpotFleetRequestsPaginator.this.firstRequest);
            }
            return DescribeSpotFleetRequestsPaginator.this.client.describeSpotFleetRequests((DescribeSpotFleetRequestsRequest)((Object)DescribeSpotFleetRequestsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

