/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.ServiceTypeDetail;
import software.amazon.awssdk.services.ec2.model.ServiceTypeDetailSetCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ServiceDetail
implements ToCopyableBuilder<Builder, ServiceDetail> {
    private final String serviceName;
    private final List<ServiceTypeDetail> serviceType;
    private final List<String> availabilityZones;
    private final String owner;
    private final List<String> baseEndpointDnsNames;
    private final String privateDnsName;
    private final Boolean vpcEndpointPolicySupported;
    private final Boolean acceptanceRequired;

    private ServiceDetail(BuilderImpl builder) {
        this.serviceName = builder.serviceName;
        this.serviceType = builder.serviceType;
        this.availabilityZones = builder.availabilityZones;
        this.owner = builder.owner;
        this.baseEndpointDnsNames = builder.baseEndpointDnsNames;
        this.privateDnsName = builder.privateDnsName;
        this.vpcEndpointPolicySupported = builder.vpcEndpointPolicySupported;
        this.acceptanceRequired = builder.acceptanceRequired;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public List<ServiceTypeDetail> serviceType() {
        return this.serviceType;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public String owner() {
        return this.owner;
    }

    public List<String> baseEndpointDnsNames() {
        return this.baseEndpointDnsNames;
    }

    public String privateDnsName() {
        return this.privateDnsName;
    }

    public Boolean vpcEndpointPolicySupported() {
        return this.vpcEndpointPolicySupported;
    }

    public Boolean acceptanceRequired() {
        return this.acceptanceRequired;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseEndpointDnsNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointPolicySupported());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptanceRequired());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceDetail)) {
            return false;
        }
        ServiceDetail other = (ServiceDetail)obj;
        return Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.serviceType(), other.serviceType()) && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.baseEndpointDnsNames(), other.baseEndpointDnsNames()) && Objects.equals(this.privateDnsName(), other.privateDnsName()) && Objects.equals(this.vpcEndpointPolicySupported(), other.vpcEndpointPolicySupported()) && Objects.equals(this.acceptanceRequired(), other.acceptanceRequired());
    }

    public String toString() {
        return ToString.builder((String)"ServiceDetail").add("ServiceName", (Object)this.serviceName()).add("ServiceType", this.serviceType()).add("AvailabilityZones", this.availabilityZones()).add("Owner", (Object)this.owner()).add("BaseEndpointDnsNames", this.baseEndpointDnsNames()).add("PrivateDnsName", (Object)this.privateDnsName()).add("VpcEndpointPolicySupported", (Object)this.vpcEndpointPolicySupported()).add("AcceptanceRequired", (Object)this.acceptanceRequired()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceName": {
                return Optional.of(clazz.cast(this.serviceName()));
            }
            case "ServiceType": {
                return Optional.of(clazz.cast(this.serviceType()));
            }
            case "AvailabilityZones": {
                return Optional.of(clazz.cast(this.availabilityZones()));
            }
            case "Owner": {
                return Optional.of(clazz.cast(this.owner()));
            }
            case "BaseEndpointDnsNames": {
                return Optional.of(clazz.cast(this.baseEndpointDnsNames()));
            }
            case "PrivateDnsName": {
                return Optional.of(clazz.cast(this.privateDnsName()));
            }
            case "VpcEndpointPolicySupported": {
                return Optional.of(clazz.cast(this.vpcEndpointPolicySupported()));
            }
            case "AcceptanceRequired": {
                return Optional.of(clazz.cast(this.acceptanceRequired()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceName;
        private List<ServiceTypeDetail> serviceType;
        private List<String> availabilityZones;
        private String owner;
        private List<String> baseEndpointDnsNames;
        private String privateDnsName;
        private Boolean vpcEndpointPolicySupported;
        private Boolean acceptanceRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceDetail model) {
            this.serviceName(model.serviceName);
            this.serviceType(model.serviceType);
            this.availabilityZones(model.availabilityZones);
            this.owner(model.owner);
            this.baseEndpointDnsNames(model.baseEndpointDnsNames);
            this.privateDnsName(model.privateDnsName);
            this.vpcEndpointPolicySupported(model.vpcEndpointPolicySupported);
            this.acceptanceRequired(model.acceptanceRequired);
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final Collection<ServiceTypeDetail.Builder> getServiceType() {
            return this.serviceType != null ? (Collection)this.serviceType.stream().map(ServiceTypeDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceType(Collection<ServiceTypeDetail> serviceType) {
            this.serviceType = ServiceTypeDetailSetCopier.copy(serviceType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceType(ServiceTypeDetail ... serviceType) {
            this.serviceType(Arrays.asList(serviceType));
            return this;
        }

        public final void setServiceType(Collection<ServiceTypeDetail.BuilderImpl> serviceType) {
            this.serviceType = ServiceTypeDetailSetCopier.copyFromBuilder(serviceType);
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ValueStringListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ValueStringListCopier.copy(availabilityZones);
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final Collection<String> getBaseEndpointDnsNames() {
            return this.baseEndpointDnsNames;
        }

        @Override
        public final Builder baseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
            this.baseEndpointDnsNames = ValueStringListCopier.copy(baseEndpointDnsNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseEndpointDnsNames(String ... baseEndpointDnsNames) {
            this.baseEndpointDnsNames(Arrays.asList(baseEndpointDnsNames));
            return this;
        }

        public final void setBaseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
            this.baseEndpointDnsNames = ValueStringListCopier.copy(baseEndpointDnsNames);
        }

        public final String getPrivateDnsName() {
            return this.privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final Boolean getVpcEndpointPolicySupported() {
            return this.vpcEndpointPolicySupported;
        }

        @Override
        public final Builder vpcEndpointPolicySupported(Boolean vpcEndpointPolicySupported) {
            this.vpcEndpointPolicySupported = vpcEndpointPolicySupported;
            return this;
        }

        public final void setVpcEndpointPolicySupported(Boolean vpcEndpointPolicySupported) {
            this.vpcEndpointPolicySupported = vpcEndpointPolicySupported;
        }

        public final Boolean getAcceptanceRequired() {
            return this.acceptanceRequired;
        }

        @Override
        public final Builder acceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        public final void setAcceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
        }

        public ServiceDetail build() {
            return new ServiceDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ServiceDetail> {
        public Builder serviceName(String var1);

        public Builder serviceType(Collection<ServiceTypeDetail> var1);

        public Builder serviceType(ServiceTypeDetail ... var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder owner(String var1);

        public Builder baseEndpointDnsNames(Collection<String> var1);

        public Builder baseEndpointDnsNames(String ... var1);

        public Builder privateDnsName(String var1);

        public Builder vpcEndpointPolicySupported(Boolean var1);

        public Builder acceptanceRequired(Boolean var1);
    }
}

