/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.VpcClassicLink;
import software.amazon.awssdk.services.ec2.model.VpcClassicLinkListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVpcClassicLinkResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribeVpcClassicLinkResponse> {
    private final List<VpcClassicLink> vpcs;

    private DescribeVpcClassicLinkResponse(BuilderImpl builder) {
        super(builder);
        this.vpcs = builder.vpcs;
    }

    public List<VpcClassicLink> vpcs() {
        return this.vpcs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcClassicLinkResponse)) {
            return false;
        }
        DescribeVpcClassicLinkResponse other = (DescribeVpcClassicLinkResponse)((Object)obj);
        return Objects.equals(this.vpcs(), other.vpcs());
    }

    public String toString() {
        return ToString.builder((String)"DescribeVpcClassicLinkResponse").add("Vpcs", this.vpcs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Vpcs": {
                return Optional.of(clazz.cast(this.vpcs()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<VpcClassicLink> vpcs;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcClassicLinkResponse model) {
            this.vpcs(model.vpcs);
        }

        public final Collection<VpcClassicLink.Builder> getVpcs() {
            return this.vpcs != null ? (Collection)this.vpcs.stream().map(VpcClassicLink::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcs(Collection<VpcClassicLink> vpcs) {
            this.vpcs = VpcClassicLinkListCopier.copy(vpcs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcs(VpcClassicLink ... vpcs) {
            this.vpcs(Arrays.asList(vpcs));
            return this;
        }

        public final void setVpcs(Collection<VpcClassicLink.BuilderImpl> vpcs) {
            this.vpcs = VpcClassicLinkListCopier.copyFromBuilder(vpcs);
        }

        @Override
        public DescribeVpcClassicLinkResponse build() {
            return new DescribeVpcClassicLinkResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribeVpcClassicLinkResponse> {
        public Builder vpcs(Collection<VpcClassicLink> var1);

        public Builder vpcs(VpcClassicLink ... var1);
    }
}

