/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.ServiceDetail;
import software.amazon.awssdk.services.ec2.model.ServiceTypeDetail;
import software.amazon.awssdk.services.ec2.transform.ServiceTypeDetailUnmarshaller;

public class ServiceDetailUnmarshaller
implements Unmarshaller<ServiceDetail, StaxUnmarshallerContext> {
    private static final ServiceDetailUnmarshaller INSTANCE = new ServiceDetailUnmarshaller();

    public ServiceDetail unmarshall(StaxUnmarshallerContext context) throws Exception {
        ServiceDetail.Builder serviceDetail;
        block14: {
            serviceDetail = ServiceDetail.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<ServiceTypeDetail> serviceType = null;
            ArrayList<String> availabilityZones = null;
            ArrayList<String> baseEndpointDnsNames = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    serviceDetail.serviceType(serviceType);
                    serviceDetail.availabilityZones(availabilityZones);
                    serviceDetail.baseEndpointDnsNames(baseEndpointDnsNames);
                    break block14;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("serviceName", targetDepth)) {
                        serviceDetail.serviceName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("serviceType", targetDepth)) {
                        serviceType = new ArrayList<ServiceTypeDetail>();
                        continue;
                    }
                    if (context.testExpression("serviceType/item", targetDepth)) {
                        serviceType.add(ServiceTypeDetailUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("availabilityZoneSet", targetDepth)) {
                        availabilityZones = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("availabilityZoneSet/item", targetDepth)) {
                        availabilityZones.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("owner", targetDepth)) {
                        serviceDetail.owner(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("baseEndpointDnsNameSet", targetDepth)) {
                        baseEndpointDnsNames = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("baseEndpointDnsNameSet/item", targetDepth)) {
                        baseEndpointDnsNames.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("privateDnsName", targetDepth)) {
                        serviceDetail.privateDnsName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("vpcEndpointPolicySupported", targetDepth)) {
                        serviceDetail.vpcEndpointPolicySupported(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("acceptanceRequired", targetDepth)) continue;
                    serviceDetail.acceptanceRequired(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            serviceDetail.serviceType(serviceType);
            serviceDetail.availabilityZones(availabilityZones);
            serviceDetail.baseEndpointDnsNames(baseEndpointDnsNames);
        }
        return (ServiceDetail)serviceDetail.build();
    }

    public static ServiceDetailUnmarshaller getInstance() {
        return INSTANCE;
    }
}

