/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.ModifyIdFormatRequest;

public class ModifyIdFormatRequestMarshaller
implements Marshaller<Request<ModifyIdFormatRequest>, ModifyIdFormatRequest> {
    public Request<ModifyIdFormatRequest> marshall(ModifyIdFormatRequest modifyIdFormatRequest) {
        if (modifyIdFormatRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)modifyIdFormatRequest, "EC2Client");
        request.addParameter("Action", "ModifyIdFormat");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyIdFormatRequest.resource() != null) {
            request.addParameter("Resource", StringUtils.fromString((String)modifyIdFormatRequest.resource()));
        }
        if (modifyIdFormatRequest.useLongIds() != null) {
            request.addParameter("UseLongIds", StringUtils.fromBoolean((Boolean)modifyIdFormatRequest.useLongIds()));
        }
        return request;
    }
}

