/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeNetworkInterfacePermissionsRequestMarshaller
implements Marshaller<Request<DescribeNetworkInterfacePermissionsRequest>, DescribeNetworkInterfacePermissionsRequest> {
    public Request<DescribeNetworkInterfacePermissionsRequest> marshall(DescribeNetworkInterfacePermissionsRequest describeNetworkInterfacePermissionsRequest) {
        List<Filter> describeNetworkInterfacePermissionsRequestFiltersList;
        if (describeNetworkInterfacePermissionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeNetworkInterfacePermissionsRequest, "EC2Client");
        request.addParameter("Action", "DescribeNetworkInterfacePermissions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeNetworkInterfacePermissionsRequestNetworkInterfacePermissionIdsList = describeNetworkInterfacePermissionsRequest.networkInterfacePermissionIds();
        if (describeNetworkInterfacePermissionsRequestNetworkInterfacePermissionIdsList != null) {
            int networkInterfacePermissionIdsListIndex = 1;
            for (String describeNetworkInterfacePermissionsRequestNetworkInterfacePermissionIdsListValue : describeNetworkInterfacePermissionsRequestNetworkInterfacePermissionIdsList) {
                if (describeNetworkInterfacePermissionsRequestNetworkInterfacePermissionIdsListValue != null) {
                    request.addParameter("NetworkInterfacePermissionId." + networkInterfacePermissionIdsListIndex, StringUtils.fromString((String)describeNetworkInterfacePermissionsRequestNetworkInterfacePermissionIdsListValue));
                }
                ++networkInterfacePermissionIdsListIndex;
            }
        }
        if ((describeNetworkInterfacePermissionsRequestFiltersList = describeNetworkInterfacePermissionsRequest.filters()) != null) {
            int filtersListIndex = 1;
            for (Filter describeNetworkInterfacePermissionsRequestFiltersListValue : describeNetworkInterfacePermissionsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeNetworkInterfacePermissionsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeNetworkInterfacePermissionsRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeNetworkInterfacePermissionsRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeNetworkInterfacePermissionsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeNetworkInterfacePermissionsRequest.nextToken()));
        }
        if (describeNetworkInterfacePermissionsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeNetworkInterfacePermissionsRequest.maxResults()));
        }
        return request;
    }
}

