/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeNetworkAclsRequestMarshaller
implements Marshaller<Request<DescribeNetworkAclsRequest>, DescribeNetworkAclsRequest> {
    public Request<DescribeNetworkAclsRequest> marshall(DescribeNetworkAclsRequest describeNetworkAclsRequest) {
        List<String> describeNetworkAclsRequestNetworkAclIdsList;
        if (describeNetworkAclsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeNetworkAclsRequest, "EC2Client");
        request.addParameter("Action", "DescribeNetworkAcls");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeNetworkAclsRequestFiltersList = describeNetworkAclsRequest.filters();
        if (describeNetworkAclsRequestFiltersList != null) {
            int filtersListIndex = 1;
            for (Filter describeNetworkAclsRequestFiltersListValue : describeNetworkAclsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeNetworkAclsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeNetworkAclsRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeNetworkAclsRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if ((describeNetworkAclsRequestNetworkAclIdsList = describeNetworkAclsRequest.networkAclIds()) != null) {
            int networkAclIdsListIndex = 1;
            for (String describeNetworkAclsRequestNetworkAclIdsListValue : describeNetworkAclsRequestNetworkAclIdsList) {
                if (describeNetworkAclsRequestNetworkAclIdsListValue != null) {
                    request.addParameter("NetworkAclId." + networkAclIdsListIndex, StringUtils.fromString((String)describeNetworkAclsRequestNetworkAclIdsListValue));
                }
                ++networkAclIdsListIndex;
            }
        }
        return request;
    }
}

