/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.DhcpConfiguration;

public class CreateDhcpOptionsRequestMarshaller
implements Marshaller<Request<CreateDhcpOptionsRequest>, CreateDhcpOptionsRequest> {
    public Request<CreateDhcpOptionsRequest> marshall(CreateDhcpOptionsRequest createDhcpOptionsRequest) {
        if (createDhcpOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createDhcpOptionsRequest, "EC2Client");
        request.addParameter("Action", "CreateDhcpOptions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<DhcpConfiguration> createDhcpOptionsRequestDhcpConfigurationsList = createDhcpOptionsRequest.dhcpConfigurations();
        if (createDhcpOptionsRequestDhcpConfigurationsList != null) {
            int dhcpConfigurationsListIndex = 1;
            for (DhcpConfiguration createDhcpOptionsRequestDhcpConfigurationsListValue : createDhcpOptionsRequestDhcpConfigurationsList) {
                List<String> dhcpConfigurationValuesList;
                if (createDhcpOptionsRequestDhcpConfigurationsListValue.key() != null) {
                    request.addParameter("DhcpConfiguration." + dhcpConfigurationsListIndex + ".Key", StringUtils.fromString((String)createDhcpOptionsRequestDhcpConfigurationsListValue.key()));
                }
                if ((dhcpConfigurationValuesList = createDhcpOptionsRequestDhcpConfigurationsListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String dhcpConfigurationValuesListValue : dhcpConfigurationValuesList) {
                        if (dhcpConfigurationValuesListValue != null) {
                            request.addParameter("DhcpConfiguration." + dhcpConfigurationsListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)dhcpConfigurationValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++dhcpConfigurationsListIndex;
            }
        }
        return request;
    }
}

