/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.InstanceCount;
import software.amazon.awssdk.services.ec2.model.InstanceCountListCopier;
import software.amazon.awssdk.services.ec2.model.ListingStatus;
import software.amazon.awssdk.services.ec2.model.PriceSchedule;
import software.amazon.awssdk.services.ec2.model.PriceScheduleListCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReservedInstancesListing
implements ToCopyableBuilder<Builder, ReservedInstancesListing> {
    private final String clientToken;
    private final Instant createDate;
    private final List<InstanceCount> instanceCounts;
    private final List<PriceSchedule> priceSchedules;
    private final String reservedInstancesId;
    private final String reservedInstancesListingId;
    private final String status;
    private final String statusMessage;
    private final List<Tag> tags;
    private final Instant updateDate;

    private ReservedInstancesListing(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.createDate = builder.createDate;
        this.instanceCounts = builder.instanceCounts;
        this.priceSchedules = builder.priceSchedules;
        this.reservedInstancesId = builder.reservedInstancesId;
        this.reservedInstancesListingId = builder.reservedInstancesListingId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.tags = builder.tags;
        this.updateDate = builder.updateDate;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public List<InstanceCount> instanceCounts() {
        return this.instanceCounts;
    }

    public List<PriceSchedule> priceSchedules() {
        return this.priceSchedules;
    }

    public String reservedInstancesId() {
        return this.reservedInstancesId;
    }

    public String reservedInstancesListingId() {
        return this.reservedInstancesListingId;
    }

    public ListingStatus status() {
        return ListingStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Instant updateDate() {
        return this.updateDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.priceSchedules());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesListingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesListing)) {
            return false;
        }
        ReservedInstancesListing other = (ReservedInstancesListing)obj;
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.instanceCounts(), other.instanceCounts()) && Objects.equals(this.priceSchedules(), other.priceSchedules()) && Objects.equals(this.reservedInstancesId(), other.reservedInstancesId()) && Objects.equals(this.reservedInstancesListingId(), other.reservedInstancesListingId()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.updateDate(), other.updateDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        if (this.instanceCounts() != null) {
            sb.append("InstanceCounts: ").append(this.instanceCounts()).append(",");
        }
        if (this.priceSchedules() != null) {
            sb.append("PriceSchedules: ").append(this.priceSchedules()).append(",");
        }
        if (this.reservedInstancesId() != null) {
            sb.append("ReservedInstancesId: ").append(this.reservedInstancesId()).append(",");
        }
        if (this.reservedInstancesListingId() != null) {
            sb.append("ReservedInstancesListingId: ").append(this.reservedInstancesListingId()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.statusMessage() != null) {
            sb.append("StatusMessage: ").append(this.statusMessage()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.updateDate() != null) {
            sb.append("UpdateDate: ").append(this.updateDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
            case "CreateDate": {
                return Optional.of(clazz.cast(this.createDate()));
            }
            case "InstanceCounts": {
                return Optional.of(clazz.cast(this.instanceCounts()));
            }
            case "PriceSchedules": {
                return Optional.of(clazz.cast(this.priceSchedules()));
            }
            case "ReservedInstancesId": {
                return Optional.of(clazz.cast(this.reservedInstancesId()));
            }
            case "ReservedInstancesListingId": {
                return Optional.of(clazz.cast(this.reservedInstancesListingId()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "StatusMessage": {
                return Optional.of(clazz.cast(this.statusMessage()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "UpdateDate": {
                return Optional.of(clazz.cast(this.updateDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String clientToken;
        private Instant createDate;
        private List<InstanceCount> instanceCounts;
        private List<PriceSchedule> priceSchedules;
        private String reservedInstancesId;
        private String reservedInstancesListingId;
        private String status;
        private String statusMessage;
        private List<Tag> tags;
        private Instant updateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesListing model) {
            this.clientToken(model.clientToken);
            this.createDate(model.createDate);
            this.instanceCounts(model.instanceCounts);
            this.priceSchedules(model.priceSchedules);
            this.reservedInstancesId(model.reservedInstancesId);
            this.reservedInstancesListingId(model.reservedInstancesListingId);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.tags(model.tags);
            this.updateDate(model.updateDate);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Collection<InstanceCount.Builder> getInstanceCounts() {
            return this.instanceCounts != null ? (Collection)this.instanceCounts.stream().map(InstanceCount::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceCounts(Collection<InstanceCount> instanceCounts) {
            this.instanceCounts = InstanceCountListCopier.copy(instanceCounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceCounts(InstanceCount ... instanceCounts) {
            this.instanceCounts(Arrays.asList(instanceCounts));
            return this;
        }

        public final void setInstanceCounts(Collection<InstanceCount.BuilderImpl> instanceCounts) {
            this.instanceCounts = InstanceCountListCopier.copyFromBuilder(instanceCounts);
        }

        public final Collection<PriceSchedule.Builder> getPriceSchedules() {
            return this.priceSchedules != null ? (Collection)this.priceSchedules.stream().map(PriceSchedule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder priceSchedules(Collection<PriceSchedule> priceSchedules) {
            this.priceSchedules = PriceScheduleListCopier.copy(priceSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceSchedules(PriceSchedule ... priceSchedules) {
            this.priceSchedules(Arrays.asList(priceSchedules));
            return this;
        }

        public final void setPriceSchedules(Collection<PriceSchedule.BuilderImpl> priceSchedules) {
            this.priceSchedules = PriceScheduleListCopier.copyFromBuilder(priceSchedules);
        }

        public final String getReservedInstancesId() {
            return this.reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        public final String getReservedInstancesListingId() {
            return this.reservedInstancesListingId;
        }

        @Override
        public final Builder reservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
            return this;
        }

        public final void setReservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ListingStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Instant getUpdateDate() {
            return this.updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        public ReservedInstancesListing build() {
            return new ReservedInstancesListing(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReservedInstancesListing> {
        public Builder clientToken(String var1);

        public Builder createDate(Instant var1);

        public Builder instanceCounts(Collection<InstanceCount> var1);

        public Builder instanceCounts(InstanceCount ... var1);

        public Builder priceSchedules(Collection<PriceSchedule> var1);

        public Builder priceSchedules(PriceSchedule ... var1);

        public Builder reservedInstancesId(String var1);

        public Builder reservedInstancesListingId(String var1);

        public Builder status(String var1);

        public Builder status(ListingStatus var1);

        public Builder statusMessage(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder updateDate(Instant var1);
    }
}

