/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.RequestHostIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReleaseHostsRequest
extends EC2Request
implements ToCopyableBuilder<Builder, ReleaseHostsRequest> {
    private final List<String> hostIds;

    private ReleaseHostsRequest(BuilderImpl builder) {
        super(builder);
        this.hostIds = builder.hostIds;
    }

    public List<String> hostIds() {
        return this.hostIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReleaseHostsRequest)) {
            return false;
        }
        ReleaseHostsRequest other = (ReleaseHostsRequest)((Object)obj);
        return Objects.equals(this.hostIds(), other.hostIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.hostIds() != null) {
            sb.append("HostIds: ").append(this.hostIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostIds": {
                return Optional.of(clazz.cast(this.hostIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private List<String> hostIds;

        private BuilderImpl() {
        }

        private BuilderImpl(ReleaseHostsRequest model) {
            this.hostIds(model.hostIds);
        }

        public final Collection<String> getHostIds() {
            return this.hostIds;
        }

        @Override
        public final Builder hostIds(Collection<String> hostIds) {
            this.hostIds = RequestHostIdListCopier.copy(hostIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIds(String ... hostIds) {
            this.hostIds(Arrays.asList(hostIds));
            return this;
        }

        public final void setHostIds(Collection<String> hostIds) {
            this.hostIds = RequestHostIdListCopier.copy(hostIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ReleaseHostsRequest build() {
            return new ReleaseHostsRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, ReleaseHostsRequest> {
        public Builder hostIds(Collection<String> var1);

        public Builder hostIds(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

