/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.ImportInstanceVolumeDetailItem;
import software.amazon.awssdk.services.ec2.model.ImportInstanceVolumeDetailSetCopier;
import software.amazon.awssdk.services.ec2.model.PlatformValues;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportInstanceTaskDetails
implements ToCopyableBuilder<Builder, ImportInstanceTaskDetails> {
    private final String description;
    private final String instanceId;
    private final String platform;
    private final List<ImportInstanceVolumeDetailItem> volumes;

    private ImportInstanceTaskDetails(BuilderImpl builder) {
        this.description = builder.description;
        this.instanceId = builder.instanceId;
        this.platform = builder.platform;
        this.volumes = builder.volumes;
    }

    public String description() {
        return this.description;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public PlatformValues platform() {
        return PlatformValues.fromValue(this.platform);
    }

    public String platformString() {
        return this.platform;
    }

    public List<ImportInstanceVolumeDetailItem> volumes() {
        return this.volumes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformString());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceTaskDetails)) {
            return false;
        }
        ImportInstanceTaskDetails other = (ImportInstanceTaskDetails)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.platformString(), other.platformString()) && Objects.equals(this.volumes(), other.volumes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.platformString() != null) {
            sb.append("Platform: ").append(this.platformString()).append(",");
        }
        if (this.volumes() != null) {
            sb.append("Volumes: ").append(this.volumes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "Platform": {
                return Optional.of(clazz.cast(this.platformString()));
            }
            case "Volumes": {
                return Optional.of(clazz.cast(this.volumes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String instanceId;
        private String platform;
        private List<ImportInstanceVolumeDetailItem> volumes;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportInstanceTaskDetails model) {
            this.description(model.description);
            this.instanceId(model.instanceId);
            this.platform(model.platform);
            this.volumes(model.volumes);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final Collection<ImportInstanceVolumeDetailItem.Builder> getVolumes() {
            return this.volumes != null ? (Collection)this.volumes.stream().map(ImportInstanceVolumeDetailItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumes(Collection<ImportInstanceVolumeDetailItem> volumes) {
            this.volumes = ImportInstanceVolumeDetailSetCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(ImportInstanceVolumeDetailItem ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        public final void setVolumes(Collection<ImportInstanceVolumeDetailItem.BuilderImpl> volumes) {
            this.volumes = ImportInstanceVolumeDetailSetCopier.copyFromBuilder(volumes);
        }

        public ImportInstanceTaskDetails build() {
            return new ImportInstanceTaskDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImportInstanceTaskDetails> {
        public Builder description(String var1);

        public Builder instanceId(String var1);

        public Builder platform(String var1);

        public Builder platform(PlatformValues var1);

        public Builder volumes(Collection<ImportInstanceVolumeDetailItem> var1);

        public Builder volumes(ImportInstanceVolumeDetailItem ... var1);
    }
}

