/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnableVgwRoutePropagationRequest
extends EC2Request
implements ToCopyableBuilder<Builder, EnableVgwRoutePropagationRequest> {
    private final String gatewayId;
    private final String routeTableId;

    private EnableVgwRoutePropagationRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayId = builder.gatewayId;
        this.routeTableId = builder.routeTableId;
    }

    public String gatewayId() {
        return this.gatewayId;
    }

    public String routeTableId() {
        return this.routeTableId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableVgwRoutePropagationRequest)) {
            return false;
        }
        EnableVgwRoutePropagationRequest other = (EnableVgwRoutePropagationRequest)((Object)obj);
        return Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.routeTableId(), other.routeTableId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.gatewayId() != null) {
            sb.append("GatewayId: ").append(this.gatewayId()).append(",");
        }
        if (this.routeTableId() != null) {
            sb.append("RouteTableId: ").append(this.routeTableId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayId": {
                return Optional.of(clazz.cast(this.gatewayId()));
            }
            case "RouteTableId": {
                return Optional.of(clazz.cast(this.routeTableId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String gatewayId;
        private String routeTableId;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableVgwRoutePropagationRequest model) {
            this.gatewayId(model.gatewayId);
            this.routeTableId(model.routeTableId);
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public EnableVgwRoutePropagationRequest build() {
            return new EnableVgwRoutePropagationRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, EnableVgwRoutePropagationRequest> {
        public Builder gatewayId(String var1);

        public Builder routeTableId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

