/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.VolumeStatusItem;
import software.amazon.awssdk.services.ec2.model.VolumeStatusListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVolumeStatusResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribeVolumeStatusResponse> {
    private final String nextToken;
    private final List<VolumeStatusItem> volumeStatuses;

    private DescribeVolumeStatusResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.volumeStatuses = builder.volumeStatuses;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<VolumeStatusItem> volumeStatuses() {
        return this.volumeStatuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeStatuses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumeStatusResponse)) {
            return false;
        }
        DescribeVolumeStatusResponse other = (DescribeVolumeStatusResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.volumeStatuses(), other.volumeStatuses());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.volumeStatuses() != null) {
            sb.append("VolumeStatuses: ").append(this.volumeStatuses()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "VolumeStatuses": {
                return Optional.of(clazz.cast(this.volumeStatuses()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<VolumeStatusItem> volumeStatuses;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumeStatusResponse model) {
            this.nextToken(model.nextToken);
            this.volumeStatuses(model.volumeStatuses);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VolumeStatusItem.Builder> getVolumeStatuses() {
            return this.volumeStatuses != null ? (Collection)this.volumeStatuses.stream().map(VolumeStatusItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumeStatuses(Collection<VolumeStatusItem> volumeStatuses) {
            this.volumeStatuses = VolumeStatusListCopier.copy(volumeStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeStatuses(VolumeStatusItem ... volumeStatuses) {
            this.volumeStatuses(Arrays.asList(volumeStatuses));
            return this;
        }

        public final void setVolumeStatuses(Collection<VolumeStatusItem.BuilderImpl> volumeStatuses) {
            this.volumeStatuses = VolumeStatusListCopier.copyFromBuilder(volumeStatuses);
        }

        @Override
        public DescribeVolumeStatusResponse build() {
            return new DescribeVolumeStatusResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribeVolumeStatusResponse> {
        public Builder nextToken(String var1);

        public Builder volumeStatuses(Collection<VolumeStatusItem> var1);

        public Builder volumeStatuses(VolumeStatusItem ... var1);
    }
}

