/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.ScheduledInstance;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeScheduledInstancesResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribeScheduledInstancesResponse> {
    private final String nextToken;
    private final List<ScheduledInstance> scheduledInstanceSet;

    private DescribeScheduledInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.scheduledInstanceSet = builder.scheduledInstanceSet;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<ScheduledInstance> scheduledInstanceSet() {
        return this.scheduledInstanceSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledInstanceSet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledInstancesResponse)) {
            return false;
        }
        DescribeScheduledInstancesResponse other = (DescribeScheduledInstancesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.scheduledInstanceSet(), other.scheduledInstanceSet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.scheduledInstanceSet() != null) {
            sb.append("ScheduledInstanceSet: ").append(this.scheduledInstanceSet()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "ScheduledInstanceSet": {
                return Optional.of(clazz.cast(this.scheduledInstanceSet()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ScheduledInstance> scheduledInstanceSet;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledInstancesResponse model) {
            this.nextToken(model.nextToken);
            this.scheduledInstanceSet(model.scheduledInstanceSet);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ScheduledInstance.Builder> getScheduledInstanceSet() {
            return this.scheduledInstanceSet != null ? (Collection)this.scheduledInstanceSet.stream().map(ScheduledInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scheduledInstanceSet(Collection<ScheduledInstance> scheduledInstanceSet) {
            this.scheduledInstanceSet = ScheduledInstanceSetCopier.copy(scheduledInstanceSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledInstanceSet(ScheduledInstance ... scheduledInstanceSet) {
            this.scheduledInstanceSet(Arrays.asList(scheduledInstanceSet));
            return this;
        }

        public final void setScheduledInstanceSet(Collection<ScheduledInstance.BuilderImpl> scheduledInstanceSet) {
            this.scheduledInstanceSet = ScheduledInstanceSetCopier.copyFromBuilder(scheduledInstanceSet);
        }

        @Override
        public DescribeScheduledInstancesResponse build() {
            return new DescribeScheduledInstancesResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribeScheduledInstancesResponse> {
        public Builder nextToken(String var1);

        public Builder scheduledInstanceSet(Collection<ScheduledInstance> var1);

        public Builder scheduledInstanceSet(ScheduledInstance ... var1);
    }
}

