/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.StorageLocation;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateFpgaImageRequest
extends EC2Request
implements ToCopyableBuilder<Builder, CreateFpgaImageRequest> {
    private final StorageLocation inputStorageLocation;
    private final StorageLocation logsStorageLocation;
    private final String description;
    private final String name;
    private final String clientToken;

    private CreateFpgaImageRequest(BuilderImpl builder) {
        super(builder);
        this.inputStorageLocation = builder.inputStorageLocation;
        this.logsStorageLocation = builder.logsStorageLocation;
        this.description = builder.description;
        this.name = builder.name;
        this.clientToken = builder.clientToken;
    }

    public StorageLocation inputStorageLocation() {
        return this.inputStorageLocation;
    }

    public StorageLocation logsStorageLocation() {
        return this.logsStorageLocation;
    }

    public String description() {
        return this.description;
    }

    public String name() {
        return this.name;
    }

    public String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputStorageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.logsStorageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFpgaImageRequest)) {
            return false;
        }
        CreateFpgaImageRequest other = (CreateFpgaImageRequest)((Object)obj);
        return Objects.equals(this.inputStorageLocation(), other.inputStorageLocation()) && Objects.equals(this.logsStorageLocation(), other.logsStorageLocation()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.inputStorageLocation() != null) {
            sb.append("InputStorageLocation: ").append(this.inputStorageLocation()).append(",");
        }
        if (this.logsStorageLocation() != null) {
            sb.append("LogsStorageLocation: ").append(this.logsStorageLocation()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputStorageLocation": {
                return Optional.of(clazz.cast(this.inputStorageLocation()));
            }
            case "LogsStorageLocation": {
                return Optional.of(clazz.cast(this.logsStorageLocation()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private StorageLocation inputStorageLocation;
        private StorageLocation logsStorageLocation;
        private String description;
        private String name;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFpgaImageRequest model) {
            this.inputStorageLocation(model.inputStorageLocation);
            this.logsStorageLocation(model.logsStorageLocation);
            this.description(model.description);
            this.name(model.name);
            this.clientToken(model.clientToken);
        }

        public final StorageLocation.Builder getInputStorageLocation() {
            return this.inputStorageLocation != null ? this.inputStorageLocation.toBuilder() : null;
        }

        @Override
        public final Builder inputStorageLocation(StorageLocation inputStorageLocation) {
            this.inputStorageLocation = inputStorageLocation;
            return this;
        }

        public final void setInputStorageLocation(StorageLocation.BuilderImpl inputStorageLocation) {
            this.inputStorageLocation = inputStorageLocation != null ? inputStorageLocation.build() : null;
        }

        public final StorageLocation.Builder getLogsStorageLocation() {
            return this.logsStorageLocation != null ? this.logsStorageLocation.toBuilder() : null;
        }

        @Override
        public final Builder logsStorageLocation(StorageLocation logsStorageLocation) {
            this.logsStorageLocation = logsStorageLocation;
            return this;
        }

        public final void setLogsStorageLocation(StorageLocation.BuilderImpl logsStorageLocation) {
            this.logsStorageLocation = logsStorageLocation != null ? logsStorageLocation.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateFpgaImageRequest build() {
            return new CreateFpgaImageRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, CreateFpgaImageRequest> {
        public Builder inputStorageLocation(StorageLocation var1);

        default public Builder inputStorageLocation(Consumer<StorageLocation.Builder> inputStorageLocation) {
            return this.inputStorageLocation((StorageLocation)((StorageLocation.Builder)StorageLocation.builder().apply(inputStorageLocation)).build());
        }

        public Builder logsStorageLocation(StorageLocation var1);

        default public Builder logsStorageLocation(Consumer<StorageLocation.Builder> logsStorageLocation) {
            return this.logsStorageLocation((StorageLocation)((StorageLocation.Builder)StorageLocation.builder().apply(logsStorageLocation)).build());
        }

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder clientToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

