/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ClientData
implements ToCopyableBuilder<Builder, ClientData> {
    private final String comment;
    private final Instant uploadEnd;
    private final Double uploadSize;
    private final Instant uploadStart;

    private ClientData(BuilderImpl builder) {
        this.comment = builder.comment;
        this.uploadEnd = builder.uploadEnd;
        this.uploadSize = builder.uploadSize;
        this.uploadStart = builder.uploadStart;
    }

    public String comment() {
        return this.comment;
    }

    public Instant uploadEnd() {
        return this.uploadEnd;
    }

    public Double uploadSize() {
        return this.uploadSize;
    }

    public Instant uploadStart() {
        return this.uploadStart;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadEnd());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadStart());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientData)) {
            return false;
        }
        ClientData other = (ClientData)obj;
        return Objects.equals(this.comment(), other.comment()) && Objects.equals(this.uploadEnd(), other.uploadEnd()) && Objects.equals(this.uploadSize(), other.uploadSize()) && Objects.equals(this.uploadStart(), other.uploadStart());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.comment() != null) {
            sb.append("Comment: ").append(this.comment()).append(",");
        }
        if (this.uploadEnd() != null) {
            sb.append("UploadEnd: ").append(this.uploadEnd()).append(",");
        }
        if (this.uploadSize() != null) {
            sb.append("UploadSize: ").append(this.uploadSize()).append(",");
        }
        if (this.uploadStart() != null) {
            sb.append("UploadStart: ").append(this.uploadStart()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Comment": {
                return Optional.of(clazz.cast(this.comment()));
            }
            case "UploadEnd": {
                return Optional.of(clazz.cast(this.uploadEnd()));
            }
            case "UploadSize": {
                return Optional.of(clazz.cast(this.uploadSize()));
            }
            case "UploadStart": {
                return Optional.of(clazz.cast(this.uploadStart()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String comment;
        private Instant uploadEnd;
        private Double uploadSize;
        private Instant uploadStart;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientData model) {
            this.comment(model.comment);
            this.uploadEnd(model.uploadEnd);
            this.uploadSize(model.uploadSize);
            this.uploadStart(model.uploadStart);
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final Instant getUploadEnd() {
            return this.uploadEnd;
        }

        @Override
        public final Builder uploadEnd(Instant uploadEnd) {
            this.uploadEnd = uploadEnd;
            return this;
        }

        public final void setUploadEnd(Instant uploadEnd) {
            this.uploadEnd = uploadEnd;
        }

        public final Double getUploadSize() {
            return this.uploadSize;
        }

        @Override
        public final Builder uploadSize(Double uploadSize) {
            this.uploadSize = uploadSize;
            return this;
        }

        public final void setUploadSize(Double uploadSize) {
            this.uploadSize = uploadSize;
        }

        public final Instant getUploadStart() {
            return this.uploadStart;
        }

        @Override
        public final Builder uploadStart(Instant uploadStart) {
            this.uploadStart = uploadStart;
            return this;
        }

        public final void setUploadStart(Instant uploadStart) {
            this.uploadStart = uploadStart;
        }

        public ClientData build() {
            return new ClientData(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ClientData> {
        public Builder comment(String var1);

        public Builder uploadEnd(Instant var1);

        public Builder uploadSize(Double var1);

        public Builder uploadStart(Instant var1);
    }
}

