/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.AvailableInstanceCapacityListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceCapacity;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AvailableCapacity
implements ToCopyableBuilder<Builder, AvailableCapacity> {
    private final List<InstanceCapacity> availableInstanceCapacity;
    private final Integer availableVCpus;

    private AvailableCapacity(BuilderImpl builder) {
        this.availableInstanceCapacity = builder.availableInstanceCapacity;
        this.availableVCpus = builder.availableVCpus;
    }

    public List<InstanceCapacity> availableInstanceCapacity() {
        return this.availableInstanceCapacity;
    }

    public Integer availableVCpus() {
        return this.availableVCpus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availableInstanceCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableVCpus());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailableCapacity)) {
            return false;
        }
        AvailableCapacity other = (AvailableCapacity)obj;
        return Objects.equals(this.availableInstanceCapacity(), other.availableInstanceCapacity()) && Objects.equals(this.availableVCpus(), other.availableVCpus());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.availableInstanceCapacity() != null) {
            sb.append("AvailableInstanceCapacity: ").append(this.availableInstanceCapacity()).append(",");
        }
        if (this.availableVCpus() != null) {
            sb.append("AvailableVCpus: ").append(this.availableVCpus()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailableInstanceCapacity": {
                return Optional.of(clazz.cast(this.availableInstanceCapacity()));
            }
            case "AvailableVCpus": {
                return Optional.of(clazz.cast(this.availableVCpus()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<InstanceCapacity> availableInstanceCapacity;
        private Integer availableVCpus;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailableCapacity model) {
            this.availableInstanceCapacity(model.availableInstanceCapacity);
            this.availableVCpus(model.availableVCpus);
        }

        public final Collection<InstanceCapacity.Builder> getAvailableInstanceCapacity() {
            return this.availableInstanceCapacity != null ? (Collection)this.availableInstanceCapacity.stream().map(InstanceCapacity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder availableInstanceCapacity(Collection<InstanceCapacity> availableInstanceCapacity) {
            this.availableInstanceCapacity = AvailableInstanceCapacityListCopier.copy(availableInstanceCapacity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableInstanceCapacity(InstanceCapacity ... availableInstanceCapacity) {
            this.availableInstanceCapacity(Arrays.asList(availableInstanceCapacity));
            return this;
        }

        public final void setAvailableInstanceCapacity(Collection<InstanceCapacity.BuilderImpl> availableInstanceCapacity) {
            this.availableInstanceCapacity = AvailableInstanceCapacityListCopier.copyFromBuilder(availableInstanceCapacity);
        }

        public final Integer getAvailableVCpus() {
            return this.availableVCpus;
        }

        @Override
        public final Builder availableVCpus(Integer availableVCpus) {
            this.availableVCpus = availableVCpus;
            return this;
        }

        public final void setAvailableVCpus(Integer availableVCpus) {
            this.availableVCpus = availableVCpus;
        }

        public AvailableCapacity build() {
            return new AvailableCapacity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AvailableCapacity> {
        public Builder availableInstanceCapacity(Collection<InstanceCapacity> var1);

        public Builder availableInstanceCapacity(InstanceCapacity ... var1);

        public Builder availableVCpus(Integer var1);
    }
}

