/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.Storage;
import software.amazon.awssdk.services.ec2.transform.S3StorageUnmarshaller;

public class StorageUnmarshaller
implements Unmarshaller<Storage, StaxUnmarshallerContext> {
    private static final StorageUnmarshaller INSTANCE = new StorageUnmarshaller();

    public Storage unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Storage.Builder storage = Storage.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("S3", targetDepth)) continue;
                storage.s3(S3StorageUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Storage)storage.build();
    }

    public static StorageUnmarshaller getInstance() {
        return INSTANCE;
    }
}

