/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.StopInstancesRequest;

public class StopInstancesRequestMarshaller
implements Marshaller<Request<StopInstancesRequest>, StopInstancesRequest> {
    public Request<StopInstancesRequest> marshall(StopInstancesRequest stopInstancesRequest) {
        if (stopInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)stopInstancesRequest, "EC2Client");
        request.addParameter("Action", "StopInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> stopInstancesRequestInstanceIdsList = stopInstancesRequest.instanceIds();
        if (stopInstancesRequestInstanceIdsList != null) {
            int instanceIdsListIndex = 1;
            for (String stopInstancesRequestInstanceIdsListValue : stopInstancesRequestInstanceIdsList) {
                if (stopInstancesRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString((String)stopInstancesRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (stopInstancesRequest.force() != null) {
            request.addParameter("Force", StringUtils.fromBoolean((Boolean)stopInstancesRequest.force()));
        }
        return request;
    }
}

