/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.RunScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesBlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesEbs;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesIamInstanceProfile;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesIpv6Address;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesLaunchSpecification;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesMonitoring;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesNetworkInterface;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesPlacement;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig;

public class RunScheduledInstancesRequestMarshaller
implements Marshaller<Request<RunScheduledInstancesRequest>, RunScheduledInstancesRequest> {
    /*
     * Could not resolve type clashes
     */
    public Request<RunScheduledInstancesRequest> marshall(RunScheduledInstancesRequest runScheduledInstancesRequest) {
        ScheduledInstancesLaunchSpecification launchSpecification;
        if (runScheduledInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)runScheduledInstancesRequest, "EC2Client");
        request.addParameter("Action", "RunScheduledInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)runScheduledInstancesRequest.clientToken()));
        if (runScheduledInstancesRequest.instanceCount() != null) {
            request.addParameter("InstanceCount", StringUtils.fromInteger((Integer)runScheduledInstancesRequest.instanceCount()));
        }
        if ((launchSpecification = runScheduledInstancesRequest.launchSpecification()) != null) {
            List<String> scheduledInstancesLaunchSpecificationSecurityGroupIdsList;
            ScheduledInstancesPlacement placement;
            List<ScheduledInstancesNetworkInterface> scheduledInstancesLaunchSpecificationNetworkInterfacesList;
            ScheduledInstancesMonitoring monitoring;
            ScheduledInstancesIamInstanceProfile iamInstanceProfile;
            List<ScheduledInstancesBlockDeviceMapping> scheduledInstancesLaunchSpecificationBlockDeviceMappingsList = launchSpecification.blockDeviceMappings();
            if (scheduledInstancesLaunchSpecificationBlockDeviceMappingsList != null) {
                int blockDeviceMappingsListIndex = 1;
                for (ScheduledInstancesBlockDeviceMapping scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue : scheduledInstancesLaunchSpecificationBlockDeviceMappingsList) {
                    ScheduledInstancesEbs ebs;
                    if (scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.deviceName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.deviceName()));
                    }
                    if ((ebs = scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.ebs()) != null) {
                        if (ebs.deleteOnTermination() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)ebs.deleteOnTermination()));
                        }
                        if (ebs.encrypted() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean((Boolean)ebs.encrypted()));
                        }
                        if (ebs.iops() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger((Integer)ebs.iops()));
                        }
                        if (ebs.snapshotId() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString((String)ebs.snapshotId()));
                        }
                        if (ebs.volumeSize() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger((Integer)ebs.volumeSize()));
                        }
                        if (ebs.volumeType() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString((String)ebs.volumeType()));
                        }
                    }
                    if (scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.noDevice() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString((String)scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.noDevice()));
                    }
                    if (scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.virtualName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.virtualName()));
                    }
                    ++blockDeviceMappingsListIndex;
                }
            }
            if (launchSpecification.ebsOptimized() != null) {
                request.addParameter("LaunchSpecification.EbsOptimized", StringUtils.fromBoolean((Boolean)launchSpecification.ebsOptimized()));
            }
            if ((iamInstanceProfile = launchSpecification.iamInstanceProfile()) != null) {
                if (iamInstanceProfile.arn() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Arn", StringUtils.fromString((String)iamInstanceProfile.arn()));
                }
                if (iamInstanceProfile.name() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Name", StringUtils.fromString((String)iamInstanceProfile.name()));
                }
            }
            if (launchSpecification.imageId() != null) {
                request.addParameter("LaunchSpecification.ImageId", StringUtils.fromString((String)launchSpecification.imageId()));
            }
            if (launchSpecification.instanceType() != null) {
                request.addParameter("LaunchSpecification.InstanceType", StringUtils.fromString((String)launchSpecification.instanceType()));
            }
            if (launchSpecification.kernelId() != null) {
                request.addParameter("LaunchSpecification.KernelId", StringUtils.fromString((String)launchSpecification.kernelId()));
            }
            if (launchSpecification.keyName() != null) {
                request.addParameter("LaunchSpecification.KeyName", StringUtils.fromString((String)launchSpecification.keyName()));
            }
            if ((monitoring = launchSpecification.monitoring()) != null && monitoring.enabled() != null) {
                request.addParameter("LaunchSpecification.Monitoring.Enabled", StringUtils.fromBoolean((Boolean)monitoring.enabled()));
            }
            if ((scheduledInstancesLaunchSpecificationNetworkInterfacesList = launchSpecification.networkInterfaces()) != null) {
                int networkInterfacesListIndex = 1;
                for (ScheduledInstancesNetworkInterface scheduledInstancesLaunchSpecificationNetworkInterfacesListValue : scheduledInstancesLaunchSpecificationNetworkInterfacesList) {
                    List<ScheduledInstancesPrivateIpAddressConfig> scheduledInstancesNetworkInterfacePrivateIpAddressConfigsList;
                    List<ScheduledInstancesIpv6Address> scheduledInstancesNetworkInterfaceIpv6AddressesList;
                    List<String> scheduledInstancesNetworkInterfaceGroupsList;
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.associatePublicIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringUtils.fromBoolean((Boolean)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.associatePublicIpAddress()));
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.deleteOnTermination() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean((Boolean)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.deleteOnTermination()));
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.description() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Description", StringUtils.fromString((String)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.description()));
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.deviceIndex() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger((Integer)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.deviceIndex()));
                    }
                    if ((scheduledInstancesNetworkInterfaceGroupsList = scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.groups()) != null) {
                        int groupsListIndex = 1;
                        for (Object scheduledInstancesNetworkInterfaceGroupsListValue : scheduledInstancesNetworkInterfaceGroupsList) {
                            if (scheduledInstancesNetworkInterfaceGroupsListValue != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Group." + groupsListIndex, StringUtils.fromString((String)scheduledInstancesNetworkInterfaceGroupsListValue));
                            }
                            ++groupsListIndex;
                        }
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.ipv6AddressCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Ipv6AddressCount", StringUtils.fromInteger((Integer)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.ipv6AddressCount()));
                    }
                    if ((scheduledInstancesNetworkInterfaceIpv6AddressesList = scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.ipv6Addresses()) != null) {
                        Object scheduledInstancesNetworkInterfaceGroupsListValue;
                        int ipv6AddressesListIndex = 1;
                        scheduledInstancesNetworkInterfaceGroupsListValue = scheduledInstancesNetworkInterfaceIpv6AddressesList.iterator();
                        while (scheduledInstancesNetworkInterfaceGroupsListValue.hasNext()) {
                            ScheduledInstancesIpv6Address scheduledInstancesNetworkInterfaceIpv6AddressesListValue = (ScheduledInstancesIpv6Address)scheduledInstancesNetworkInterfaceGroupsListValue.next();
                            if (scheduledInstancesNetworkInterfaceIpv6AddressesListValue.ipv6Address() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Ipv6Address." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils.fromString((String)scheduledInstancesNetworkInterfaceIpv6AddressesListValue.ipv6Address()));
                            }
                            ++ipv6AddressesListIndex;
                        }
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.networkInterfaceId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString((String)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.networkInterfaceId()));
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.privateIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.privateIpAddress()));
                    }
                    if ((scheduledInstancesNetworkInterfacePrivateIpAddressConfigsList = scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.privateIpAddressConfigs()) != null) {
                        int privateIpAddressConfigsListIndex = 1;
                        for (ScheduledInstancesPrivateIpAddressConfig scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue : scheduledInstancesNetworkInterfacePrivateIpAddressConfigsList) {
                            if (scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue.primary() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddressConfig." + privateIpAddressConfigsListIndex + ".Primary", StringUtils.fromBoolean((Boolean)scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue.primary()));
                            }
                            if (scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue.privateIpAddress() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddressConfig." + privateIpAddressConfigsListIndex + ".PrivateIpAddress", StringUtils.fromString((String)scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue.privateIpAddress()));
                            }
                            ++privateIpAddressConfigsListIndex;
                        }
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.secondaryPrivateIpAddressCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.secondaryPrivateIpAddressCount()));
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.subnetId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString((String)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.subnetId()));
                    }
                    ++networkInterfacesListIndex;
                }
            }
            if ((placement = launchSpecification.placement()) != null) {
                if (placement.availabilityZone() != null) {
                    request.addParameter("LaunchSpecification.Placement.AvailabilityZone", StringUtils.fromString((String)placement.availabilityZone()));
                }
                if (placement.groupName() != null) {
                    request.addParameter("LaunchSpecification.Placement.GroupName", StringUtils.fromString((String)placement.groupName()));
                }
            }
            if (launchSpecification.ramdiskId() != null) {
                request.addParameter("LaunchSpecification.RamdiskId", StringUtils.fromString((String)launchSpecification.ramdiskId()));
            }
            if ((scheduledInstancesLaunchSpecificationSecurityGroupIdsList = launchSpecification.securityGroupIds()) != null) {
                int securityGroupIdsListIndex = 1;
                for (String scheduledInstancesLaunchSpecificationSecurityGroupIdsListValue : scheduledInstancesLaunchSpecificationSecurityGroupIdsList) {
                    if (scheduledInstancesLaunchSpecificationSecurityGroupIdsListValue != null) {
                        request.addParameter("LaunchSpecification.SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)scheduledInstancesLaunchSpecificationSecurityGroupIdsListValue));
                    }
                    ++securityGroupIdsListIndex;
                }
            }
            if (launchSpecification.subnetId() != null) {
                request.addParameter("LaunchSpecification.SubnetId", StringUtils.fromString((String)launchSpecification.subnetId()));
            }
            if (launchSpecification.userData() != null) {
                request.addParameter("LaunchSpecification.UserData", StringUtils.fromString((String)launchSpecification.userData()));
            }
        }
        if (runScheduledInstancesRequest.scheduledInstanceId() != null) {
            request.addParameter("ScheduledInstanceId", StringUtils.fromString((String)runScheduledInstancesRequest.scheduledInstanceId()));
        }
        return request;
    }
}

