/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.ReleaseHostsRequest;

public class ReleaseHostsRequestMarshaller
implements Marshaller<Request<ReleaseHostsRequest>, ReleaseHostsRequest> {
    public Request<ReleaseHostsRequest> marshall(ReleaseHostsRequest releaseHostsRequest) {
        if (releaseHostsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)releaseHostsRequest, "EC2Client");
        request.addParameter("Action", "ReleaseHosts");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> releaseHostsRequestHostIdsList = releaseHostsRequest.hostIds();
        if (releaseHostsRequestHostIdsList != null) {
            int hostIdsListIndex = 1;
            for (String releaseHostsRequestHostIdsListValue : releaseHostsRequestHostIdsList) {
                if (releaseHostsRequestHostIdsListValue != null) {
                    request.addParameter("HostId." + hostIdsListIndex, StringUtils.fromString((String)releaseHostsRequestHostIdsListValue));
                }
                ++hostIdsListIndex;
            }
        }
        return request;
    }
}

