/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DiskImage;
import software.amazon.awssdk.services.ec2.model.DiskImageDetail;
import software.amazon.awssdk.services.ec2.model.ImportInstanceLaunchSpecification;
import software.amazon.awssdk.services.ec2.model.ImportInstanceRequest;
import software.amazon.awssdk.services.ec2.model.Placement;
import software.amazon.awssdk.services.ec2.model.UserData;
import software.amazon.awssdk.services.ec2.model.VolumeDetail;

public class ImportInstanceRequestMarshaller
implements Marshaller<Request<ImportInstanceRequest>, ImportInstanceRequest> {
    public Request<ImportInstanceRequest> marshall(ImportInstanceRequest importInstanceRequest) {
        ImportInstanceLaunchSpecification launchSpecification;
        List<DiskImage> importInstanceRequestDiskImagesList;
        if (importInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)importInstanceRequest, "EC2Client");
        request.addParameter("Action", "ImportInstance");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (importInstanceRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)importInstanceRequest.description()));
        }
        if ((importInstanceRequestDiskImagesList = importInstanceRequest.diskImages()) != null) {
            int diskImagesListIndex = 1;
            for (DiskImage importInstanceRequestDiskImagesListValue : importInstanceRequestDiskImagesList) {
                VolumeDetail volumeDetail;
                Object image;
                if (importInstanceRequestDiskImagesListValue.description() != null) {
                    request.addParameter("DiskImage." + diskImagesListIndex + ".Description", StringUtils.fromString((String)importInstanceRequestDiskImagesListValue.description()));
                }
                if ((image = importInstanceRequestDiskImagesListValue.image()) != null) {
                    if (((DiskImageDetail)image).bytes() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.Bytes", StringUtils.fromLong((Long)((DiskImageDetail)image).bytes()));
                    }
                    if (((DiskImageDetail)image).formatString() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.Format", StringUtils.fromString((String)((DiskImageDetail)image).formatString()));
                    }
                    if (((DiskImageDetail)image).importManifestUrl() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.ImportManifestUrl", StringUtils.fromString((String)((DiskImageDetail)image).importManifestUrl()));
                    }
                }
                if ((volumeDetail = importInstanceRequestDiskImagesListValue.volume()) != null && volumeDetail.size() != null) {
                    request.addParameter("DiskImage." + diskImagesListIndex + ".Volume.Size", StringUtils.fromLong((Long)volumeDetail.size()));
                }
                ++diskImagesListIndex;
            }
        }
        if ((launchSpecification = importInstanceRequest.launchSpecification()) != null) {
            UserData userData;
            Placement placement;
            List<String> importInstanceLaunchSpecificationGroupNamesList;
            List<String> importInstanceLaunchSpecificationGroupIdsList;
            if (launchSpecification.additionalInfo() != null) {
                request.addParameter("LaunchSpecification.AdditionalInfo", StringUtils.fromString((String)launchSpecification.additionalInfo()));
            }
            if (launchSpecification.architectureString() != null) {
                request.addParameter("LaunchSpecification.Architecture", StringUtils.fromString((String)launchSpecification.architectureString()));
            }
            if ((importInstanceLaunchSpecificationGroupIdsList = launchSpecification.groupIds()) != null) {
                int groupIdsListIndex = 1;
                for (String string : importInstanceLaunchSpecificationGroupIdsList) {
                    if (string != null) {
                        request.addParameter("LaunchSpecification.GroupId." + groupIdsListIndex, StringUtils.fromString((String)string));
                    }
                    ++groupIdsListIndex;
                }
            }
            if ((importInstanceLaunchSpecificationGroupNamesList = launchSpecification.groupNames()) != null) {
                int groupNamesListIndex = 1;
                for (String importInstanceLaunchSpecificationGroupNamesListValue : importInstanceLaunchSpecificationGroupNamesList) {
                    if (importInstanceLaunchSpecificationGroupNamesListValue != null) {
                        request.addParameter("LaunchSpecification.GroupName." + groupNamesListIndex, StringUtils.fromString((String)importInstanceLaunchSpecificationGroupNamesListValue));
                    }
                    ++groupNamesListIndex;
                }
            }
            if (launchSpecification.instanceInitiatedShutdownBehaviorString() != null) {
                request.addParameter("LaunchSpecification.InstanceInitiatedShutdownBehavior", StringUtils.fromString((String)launchSpecification.instanceInitiatedShutdownBehaviorString()));
            }
            if (launchSpecification.instanceTypeString() != null) {
                request.addParameter("LaunchSpecification.InstanceType", StringUtils.fromString((String)launchSpecification.instanceTypeString()));
            }
            if (launchSpecification.monitoring() != null) {
                request.addParameter("LaunchSpecification.Monitoring.Enabled", StringUtils.fromBoolean((Boolean)launchSpecification.monitoring()));
            }
            if ((placement = launchSpecification.placement()) != null) {
                if (placement.availabilityZone() != null) {
                    request.addParameter("LaunchSpecification.Placement.AvailabilityZone", StringUtils.fromString((String)placement.availabilityZone()));
                }
                if (placement.affinity() != null) {
                    request.addParameter("LaunchSpecification.Placement.Affinity", StringUtils.fromString((String)placement.affinity()));
                }
                if (placement.groupName() != null) {
                    request.addParameter("LaunchSpecification.Placement.GroupName", StringUtils.fromString((String)placement.groupName()));
                }
                if (placement.hostId() != null) {
                    request.addParameter("LaunchSpecification.Placement.HostId", StringUtils.fromString((String)placement.hostId()));
                }
                if (placement.tenancyString() != null) {
                    request.addParameter("LaunchSpecification.Placement.Tenancy", StringUtils.fromString((String)placement.tenancyString()));
                }
                if (placement.spreadDomain() != null) {
                    request.addParameter("LaunchSpecification.Placement.SpreadDomain", StringUtils.fromString((String)placement.spreadDomain()));
                }
            }
            if (launchSpecification.privateIpAddress() != null) {
                request.addParameter("LaunchSpecification.PrivateIpAddress", StringUtils.fromString((String)launchSpecification.privateIpAddress()));
            }
            if (launchSpecification.subnetId() != null) {
                request.addParameter("LaunchSpecification.SubnetId", StringUtils.fromString((String)launchSpecification.subnetId()));
            }
            if ((userData = launchSpecification.userData()) != null && userData.data() != null) {
                request.addParameter("LaunchSpecification.UserData.Data", StringUtils.fromString((String)userData.data()));
            }
        }
        if (importInstanceRequest.platformString() != null) {
            request.addParameter("Platform", StringUtils.fromString((String)importInstanceRequest.platformString()));
        }
        return request;
    }
}

