/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeVpcClassicLinkRequestMarshaller
implements Marshaller<Request<DescribeVpcClassicLinkRequest>, DescribeVpcClassicLinkRequest> {
    public Request<DescribeVpcClassicLinkRequest> marshall(DescribeVpcClassicLinkRequest describeVpcClassicLinkRequest) {
        List<String> describeVpcClassicLinkRequestVpcIdsList;
        if (describeVpcClassicLinkRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVpcClassicLinkRequest, "EC2Client");
        request.addParameter("Action", "DescribeVpcClassicLink");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeVpcClassicLinkRequestFiltersList = describeVpcClassicLinkRequest.filters();
        if (describeVpcClassicLinkRequestFiltersList != null) {
            int filtersListIndex = 1;
            for (Filter describeVpcClassicLinkRequestFiltersListValue : describeVpcClassicLinkRequestFiltersList) {
                List<String> filterValuesList;
                if (describeVpcClassicLinkRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeVpcClassicLinkRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeVpcClassicLinkRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if ((describeVpcClassicLinkRequestVpcIdsList = describeVpcClassicLinkRequest.vpcIds()) != null) {
            int vpcIdsListIndex = 1;
            for (String describeVpcClassicLinkRequestVpcIdsListValue : describeVpcClassicLinkRequestVpcIdsList) {
                if (describeVpcClassicLinkRequestVpcIdsListValue != null) {
                    request.addParameter("VpcId." + vpcIdsListIndex, StringUtils.fromString((String)describeVpcClassicLinkRequestVpcIdsListValue));
                }
                ++vpcIdsListIndex;
            }
        }
        return request;
    }
}

