/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeAvailabilityZonesRequestMarshaller
implements Marshaller<Request<DescribeAvailabilityZonesRequest>, DescribeAvailabilityZonesRequest> {
    public Request<DescribeAvailabilityZonesRequest> marshall(DescribeAvailabilityZonesRequest describeAvailabilityZonesRequest) {
        List<String> describeAvailabilityZonesRequestZoneNamesList;
        if (describeAvailabilityZonesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAvailabilityZonesRequest, "EC2Client");
        request.addParameter("Action", "DescribeAvailabilityZones");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeAvailabilityZonesRequestFiltersList = describeAvailabilityZonesRequest.filters();
        if (describeAvailabilityZonesRequestFiltersList != null) {
            int filtersListIndex = 1;
            for (Filter describeAvailabilityZonesRequestFiltersListValue : describeAvailabilityZonesRequestFiltersList) {
                List<String> filterValuesList;
                if (describeAvailabilityZonesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeAvailabilityZonesRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeAvailabilityZonesRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if ((describeAvailabilityZonesRequestZoneNamesList = describeAvailabilityZonesRequest.zoneNames()) != null) {
            int zoneNamesListIndex = 1;
            for (String describeAvailabilityZonesRequestZoneNamesListValue : describeAvailabilityZonesRequestZoneNamesList) {
                if (describeAvailabilityZonesRequestZoneNamesListValue != null) {
                    request.addParameter("ZoneName." + zoneNamesListIndex, StringUtils.fromString((String)describeAvailabilityZonesRequestZoneNamesListValue));
                }
                ++zoneNamesListIndex;
            }
        }
        return request;
    }
}

