/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DeleteSecurityGroupRequest;

public class DeleteSecurityGroupRequestMarshaller
implements Marshaller<Request<DeleteSecurityGroupRequest>, DeleteSecurityGroupRequest> {
    public Request<DeleteSecurityGroupRequest> marshall(DeleteSecurityGroupRequest deleteSecurityGroupRequest) {
        if (deleteSecurityGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteSecurityGroupRequest, "EC2Client");
        request.addParameter("Action", "DeleteSecurityGroup");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteSecurityGroupRequest.groupId() != null) {
            request.addParameter("GroupId", StringUtils.fromString((String)deleteSecurityGroupRequest.groupId()));
        }
        if (deleteSecurityGroupRequest.groupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString((String)deleteSecurityGroupRequest.groupName()));
        }
        return request;
    }
}

