/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6Address;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecification;

public class CreateNetworkInterfaceRequestMarshaller
implements Marshaller<Request<CreateNetworkInterfaceRequest>, CreateNetworkInterfaceRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<CreateNetworkInterfaceRequest> marshall(CreateNetworkInterfaceRequest createNetworkInterfaceRequest) {
        List<PrivateIpAddressSpecification> createNetworkInterfaceRequestPrivateIpAddressesList;
        List<InstanceIpv6Address> createNetworkInterfaceRequestIpv6AddressesList;
        List<String> createNetworkInterfaceRequestGroupsList;
        if (createNetworkInterfaceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createNetworkInterfaceRequest, "EC2Client");
        request.addParameter("Action", "CreateNetworkInterface");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createNetworkInterfaceRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createNetworkInterfaceRequest.description()));
        }
        if ((createNetworkInterfaceRequestGroupsList = createNetworkInterfaceRequest.groups()) != null) {
            int groupsListIndex = 1;
            for (String string : createNetworkInterfaceRequestGroupsList) {
                if (string != null) {
                    request.addParameter("SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)string));
                }
                ++groupsListIndex;
            }
        }
        if (createNetworkInterfaceRequest.ipv6AddressCount() != null) {
            request.addParameter("Ipv6AddressCount", StringUtils.fromInteger((Integer)createNetworkInterfaceRequest.ipv6AddressCount()));
        }
        if ((createNetworkInterfaceRequestIpv6AddressesList = createNetworkInterfaceRequest.ipv6Addresses()) != null) {
            int ipv6AddressesListIndex = 1;
            for (InstanceIpv6Address createNetworkInterfaceRequestIpv6AddressesListValue : createNetworkInterfaceRequestIpv6AddressesList) {
                if (createNetworkInterfaceRequestIpv6AddressesListValue.ipv6Address() != null) {
                    request.addParameter("Ipv6Addresses." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils.fromString((String)createNetworkInterfaceRequestIpv6AddressesListValue.ipv6Address()));
                }
                ++ipv6AddressesListIndex;
            }
        }
        if (createNetworkInterfaceRequest.privateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringUtils.fromString((String)createNetworkInterfaceRequest.privateIpAddress()));
        }
        if ((createNetworkInterfaceRequestPrivateIpAddressesList = createNetworkInterfaceRequest.privateIpAddresses()) != null) {
            boolean bl = true;
            for (PrivateIpAddressSpecification createNetworkInterfaceRequestPrivateIpAddressesListValue : createNetworkInterfaceRequestPrivateIpAddressesList) {
                void var6_12;
                if (createNetworkInterfaceRequestPrivateIpAddressesListValue.primary() != null) {
                    request.addParameter("PrivateIpAddresses." + (int)var6_12 + ".Primary", StringUtils.fromBoolean((Boolean)createNetworkInterfaceRequestPrivateIpAddressesListValue.primary()));
                }
                if (createNetworkInterfaceRequestPrivateIpAddressesListValue.privateIpAddress() != null) {
                    request.addParameter("PrivateIpAddresses." + (int)var6_12 + ".PrivateIpAddress", StringUtils.fromString((String)createNetworkInterfaceRequestPrivateIpAddressesListValue.privateIpAddress()));
                }
                ++var6_12;
            }
        }
        if (createNetworkInterfaceRequest.secondaryPrivateIpAddressCount() != null) {
            request.addParameter("SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)createNetworkInterfaceRequest.secondaryPrivateIpAddressCount()));
        }
        if (createNetworkInterfaceRequest.subnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString((String)createNetworkInterfaceRequest.subnetId()));
        }
        return request;
    }
}

