/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.ec2.EC2Client;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.ec2.model.Snapshot;

public final class DescribeSnapshotsPaginator
implements SdkIterable<DescribeSnapshotsResponse> {
    private final EC2Client client;
    private final DescribeSnapshotsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeSnapshotsPaginator(EC2Client client, DescribeSnapshotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeSnapshotsResponseFetcher();
    }

    public Iterator<DescribeSnapshotsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Snapshot> snapshots() {
        Function<DescribeSnapshotsResponse, Iterator> getIterator = response -> response != null ? response.snapshots().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeSnapshotsResponseFetcher
    implements NextPageFetcher<DescribeSnapshotsResponse> {
        private DescribeSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSnapshotsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeSnapshotsResponse nextPage(DescribeSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSnapshotsPaginator.this.client.describeSnapshots(DescribeSnapshotsPaginator.this.firstRequest);
            }
            return DescribeSnapshotsPaginator.this.client.describeSnapshots((DescribeSnapshotsRequest)((Object)DescribeSnapshotsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

