/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.ec2.EC2Client;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.Reservation;

public final class DescribeInstancesPaginator
implements SdkIterable<DescribeInstancesResponse> {
    private final EC2Client client;
    private final DescribeInstancesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeInstancesPaginator(EC2Client client, DescribeInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeInstancesResponseFetcher();
    }

    public Iterator<DescribeInstancesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Reservation> reservations() {
        Function<DescribeInstancesResponse, Iterator> getIterator = response -> response != null ? response.reservations().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeInstancesResponseFetcher
    implements NextPageFetcher<DescribeInstancesResponse> {
        private DescribeInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstancesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeInstancesResponse nextPage(DescribeInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstancesPaginator.this.client.describeInstances(DescribeInstancesPaginator.this.firstRequest);
            }
            return DescribeInstancesPaginator.this.client.describeInstances((DescribeInstancesRequest)((Object)DescribeInstancesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

