/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReplaceNetworkAclAssociationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ReplaceNetworkAclAssociationRequest> {
    private final String associationId;
    private final String networkAclId;

    private ReplaceNetworkAclAssociationRequest(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.networkAclId = builder.networkAclId;
    }

    public String associationId() {
        return this.associationId;
    }

    public String networkAclId() {
        return this.networkAclId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAclId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceNetworkAclAssociationRequest)) {
            return false;
        }
        ReplaceNetworkAclAssociationRequest other = (ReplaceNetworkAclAssociationRequest)((Object)obj);
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.networkAclId(), other.networkAclId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.associationId() != null) {
            sb.append("AssociationId: ").append(this.associationId()).append(",");
        }
        if (this.networkAclId() != null) {
            sb.append("NetworkAclId: ").append(this.networkAclId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.of(clazz.cast(this.associationId()));
            }
            case "NetworkAclId": {
                return Optional.of(clazz.cast(this.networkAclId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String networkAclId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceNetworkAclAssociationRequest model) {
            this.associationId(model.associationId);
            this.networkAclId(model.networkAclId);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getNetworkAclId() {
            return this.networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        public ReplaceNetworkAclAssociationRequest build() {
            return new ReplaceNetworkAclAssociationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReplaceNetworkAclAssociationRequest> {
        public Builder associationId(String var1);

        public Builder networkAclId(String var1);
    }
}

