/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReleaseAddressRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ReleaseAddressRequest> {
    private final String allocationId;
    private final String publicIp;

    private ReleaseAddressRequest(BuilderImpl builder) {
        this.allocationId = builder.allocationId;
        this.publicIp = builder.publicIp;
    }

    public String allocationId() {
        return this.allocationId;
    }

    public String publicIp() {
        return this.publicIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReleaseAddressRequest)) {
            return false;
        }
        ReleaseAddressRequest other = (ReleaseAddressRequest)((Object)obj);
        return Objects.equals(this.allocationId(), other.allocationId()) && Objects.equals(this.publicIp(), other.publicIp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.allocationId() != null) {
            sb.append("AllocationId: ").append(this.allocationId()).append(",");
        }
        if (this.publicIp() != null) {
            sb.append("PublicIp: ").append(this.publicIp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationId": {
                return Optional.of(clazz.cast(this.allocationId()));
            }
            case "PublicIp": {
                return Optional.of(clazz.cast(this.publicIp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String allocationId;
        private String publicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(ReleaseAddressRequest model) {
            this.allocationId(model.allocationId);
            this.publicIp(model.publicIp);
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public ReleaseAddressRequest build() {
            return new ReleaseAddressRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReleaseAddressRequest> {
        public Builder allocationId(String var1);

        public Builder publicIp(String var1);
    }
}

