/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NatGatewayAddress
implements ToCopyableBuilder<Builder, NatGatewayAddress> {
    private final String allocationId;
    private final String networkInterfaceId;
    private final String privateIp;
    private final String publicIp;

    private NatGatewayAddress(BuilderImpl builder) {
        this.allocationId = builder.allocationId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIp = builder.privateIp;
        this.publicIp = builder.publicIp;
    }

    public String allocationId() {
        return this.allocationId;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public String privateIp() {
        return this.privateIp;
    }

    public String publicIp() {
        return this.publicIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NatGatewayAddress)) {
            return false;
        }
        NatGatewayAddress other = (NatGatewayAddress)obj;
        return Objects.equals(this.allocationId(), other.allocationId()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.privateIp(), other.privateIp()) && Objects.equals(this.publicIp(), other.publicIp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.allocationId() != null) {
            sb.append("AllocationId: ").append(this.allocationId()).append(",");
        }
        if (this.networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.networkInterfaceId()).append(",");
        }
        if (this.privateIp() != null) {
            sb.append("PrivateIp: ").append(this.privateIp()).append(",");
        }
        if (this.publicIp() != null) {
            sb.append("PublicIp: ").append(this.publicIp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationId": {
                return Optional.of(clazz.cast(this.allocationId()));
            }
            case "NetworkInterfaceId": {
                return Optional.of(clazz.cast(this.networkInterfaceId()));
            }
            case "PrivateIp": {
                return Optional.of(clazz.cast(this.privateIp()));
            }
            case "PublicIp": {
                return Optional.of(clazz.cast(this.publicIp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String allocationId;
        private String networkInterfaceId;
        private String privateIp;
        private String publicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(NatGatewayAddress model) {
            this.allocationId(model.allocationId);
            this.networkInterfaceId(model.networkInterfaceId);
            this.privateIp(model.privateIp);
            this.publicIp(model.publicIp);
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getPrivateIp() {
            return this.privateIp;
        }

        @Override
        public final Builder privateIp(String privateIp) {
            this.privateIp = privateIp;
            return this;
        }

        public final void setPrivateIp(String privateIp) {
            this.privateIp = privateIp;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public NatGatewayAddress build() {
            return new NatGatewayAddress(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NatGatewayAddress> {
        public Builder allocationId(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder privateIp(String var1);

        public Builder publicIp(String var1);
    }
}

