/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.InstanceStateName;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceState
implements ToCopyableBuilder<Builder, InstanceState> {
    private final Integer code;
    private final String name;

    private InstanceState(BuilderImpl builder) {
        this.code = builder.code;
        this.name = builder.name;
    }

    public Integer code() {
        return this.code;
    }

    public InstanceStateName name() {
        return InstanceStateName.fromValue(this.name);
    }

    public String nameString() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceState)) {
            return false;
        }
        InstanceState other = (InstanceState)obj;
        return Objects.equals(this.code(), other.code()) && Objects.equals(this.nameString(), other.nameString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.code() != null) {
            sb.append("Code: ").append(this.code()).append(",");
        }
        if (this.nameString() != null) {
            sb.append("Name: ").append(this.nameString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Code": {
                return Optional.of(clazz.cast(this.code()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.nameString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer code;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceState model) {
            this.code(model.code);
            this.name(model.name);
        }

        public final Integer getCode() {
            return this.code;
        }

        @Override
        public final Builder code(Integer code) {
            this.code = code;
            return this;
        }

        public final void setCode(Integer code) {
            this.code = code;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(InstanceStateName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public InstanceState build() {
            return new InstanceState(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceState> {
        public Builder code(Integer var1);

        public Builder name(String var1);

        public Builder name(InstanceStateName var1);
    }
}

