/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.VpcClassicLinkIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVpcClassicLinkDnsSupportRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeVpcClassicLinkDnsSupportRequest> {
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> vpcIds;

    private DescribeVpcClassicLinkDnsSupportRequest(BuilderImpl builder) {
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.vpcIds = builder.vpcIds;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<String> vpcIds() {
        return this.vpcIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcClassicLinkDnsSupportRequest)) {
            return false;
        }
        DescribeVpcClassicLinkDnsSupportRequest other = (DescribeVpcClassicLinkDnsSupportRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.vpcIds(), other.vpcIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.vpcIds() != null) {
            sb.append("VpcIds: ").append(this.vpcIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "VpcIds": {
                return Optional.of(clazz.cast(this.vpcIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private List<String> vpcIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcClassicLinkDnsSupportRequest model) {
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.vpcIds(model.vpcIds);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getVpcIds() {
            return this.vpcIds;
        }

        @Override
        public final Builder vpcIds(Collection<String> vpcIds) {
            this.vpcIds = VpcClassicLinkIdListCopier.copy(vpcIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcIds(String ... vpcIds) {
            this.vpcIds(Arrays.asList(vpcIds));
            return this;
        }

        public final void setVpcIds(Collection<String> vpcIds) {
            this.vpcIds = VpcClassicLinkIdListCopier.copy(vpcIds);
        }

        public DescribeVpcClassicLinkDnsSupportRequest build() {
            return new DescribeVpcClassicLinkDnsSupportRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVpcClassicLinkDnsSupportRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder vpcIds(Collection<String> var1);

        public Builder vpcIds(String ... var1);
    }
}

