/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.SecurityGroupReference;
import software.amazon.awssdk.services.ec2.model.SecurityGroupReferencesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSecurityGroupReferencesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeSecurityGroupReferencesResponse> {
    private final List<SecurityGroupReference> securityGroupReferenceSet;

    private DescribeSecurityGroupReferencesResponse(BuilderImpl builder) {
        this.securityGroupReferenceSet = builder.securityGroupReferenceSet;
    }

    public List<SecurityGroupReference> securityGroupReferenceSet() {
        return this.securityGroupReferenceSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupReferenceSet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityGroupReferencesResponse)) {
            return false;
        }
        DescribeSecurityGroupReferencesResponse other = (DescribeSecurityGroupReferencesResponse)((Object)obj);
        return Objects.equals(this.securityGroupReferenceSet(), other.securityGroupReferenceSet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.securityGroupReferenceSet() != null) {
            sb.append("SecurityGroupReferenceSet: ").append(this.securityGroupReferenceSet()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityGroupReferenceSet": {
                return Optional.of(clazz.cast(this.securityGroupReferenceSet()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<SecurityGroupReference> securityGroupReferenceSet;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecurityGroupReferencesResponse model) {
            this.securityGroupReferenceSet(model.securityGroupReferenceSet);
        }

        public final Collection<SecurityGroupReference.Builder> getSecurityGroupReferenceSet() {
            return this.securityGroupReferenceSet != null ? (Collection)this.securityGroupReferenceSet.stream().map(SecurityGroupReference::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder securityGroupReferenceSet(Collection<SecurityGroupReference> securityGroupReferenceSet) {
            this.securityGroupReferenceSet = SecurityGroupReferencesCopier.copy(securityGroupReferenceSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupReferenceSet(SecurityGroupReference ... securityGroupReferenceSet) {
            this.securityGroupReferenceSet(Arrays.asList(securityGroupReferenceSet));
            return this;
        }

        public final void setSecurityGroupReferenceSet(Collection<SecurityGroupReference.BuilderImpl> securityGroupReferenceSet) {
            this.securityGroupReferenceSet = SecurityGroupReferencesCopier.copyFromBuilder(securityGroupReferenceSet);
        }

        public DescribeSecurityGroupReferencesResponse build() {
            return new DescribeSecurityGroupReferencesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSecurityGroupReferencesResponse> {
        public Builder securityGroupReferenceSet(Collection<SecurityGroupReference> var1);

        public Builder securityGroupReferenceSet(SecurityGroupReference ... var1);
    }
}

