/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.OfferingClassType;
import software.amazon.awssdk.services.ec2.model.OfferingTypeValues;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesIdStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeReservedInstancesRequest> {
    private final List<Filter> filters;
    private final String offeringClass;
    private final List<String> reservedInstancesIds;
    private final String offeringType;

    private DescribeReservedInstancesRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.offeringClass = builder.offeringClass;
        this.reservedInstancesIds = builder.reservedInstancesIds;
        this.offeringType = builder.offeringType;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public OfferingClassType offeringClass() {
        return OfferingClassType.fromValue(this.offeringClass);
    }

    public String offeringClassString() {
        return this.offeringClass;
    }

    public List<String> reservedInstancesIds() {
        return this.reservedInstancesIds;
    }

    public OfferingTypeValues offeringType() {
        return OfferingTypeValues.fromValue(this.offeringType);
    }

    public String offeringTypeString() {
        return this.offeringType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringClassString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesRequest)) {
            return false;
        }
        DescribeReservedInstancesRequest other = (DescribeReservedInstancesRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.offeringClassString(), other.offeringClassString()) && Objects.equals(this.reservedInstancesIds(), other.reservedInstancesIds()) && Objects.equals(this.offeringTypeString(), other.offeringTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.offeringClassString() != null) {
            sb.append("OfferingClass: ").append(this.offeringClassString()).append(",");
        }
        if (this.reservedInstancesIds() != null) {
            sb.append("ReservedInstancesIds: ").append(this.reservedInstancesIds()).append(",");
        }
        if (this.offeringTypeString() != null) {
            sb.append("OfferingType: ").append(this.offeringTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "OfferingClass": {
                return Optional.of(clazz.cast(this.offeringClassString()));
            }
            case "ReservedInstancesIds": {
                return Optional.of(clazz.cast(this.reservedInstancesIds()));
            }
            case "OfferingType": {
                return Optional.of(clazz.cast(this.offeringTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private String offeringClass;
        private List<String> reservedInstancesIds;
        private String offeringType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesRequest model) {
            this.filters(model.filters);
            this.offeringClass(model.offeringClass);
            this.reservedInstancesIds(model.reservedInstancesIds);
            this.offeringType(model.offeringType);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final String getOfferingClass() {
            return this.offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass.toString());
            return this;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        public final Collection<String> getReservedInstancesIds() {
            return this.reservedInstancesIds;
        }

        @Override
        public final Builder reservedInstancesIds(Collection<String> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedInstancesIdStringListCopier.copy(reservedInstancesIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesIds(String ... reservedInstancesIds) {
            this.reservedInstancesIds(Arrays.asList(reservedInstancesIds));
            return this;
        }

        public final void setReservedInstancesIds(Collection<String> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedInstancesIdStringListCopier.copy(reservedInstancesIds);
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType.toString());
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public DescribeReservedInstancesRequest build() {
            return new DescribeReservedInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeReservedInstancesRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder offeringClass(String var1);

        public Builder offeringClass(OfferingClassType var1);

        public Builder reservedInstancesIds(Collection<String> var1);

        public Builder reservedInstancesIds(String ... var1);

        public Builder offeringType(String var1);

        public Builder offeringType(OfferingTypeValues var1);
    }
}

