/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.InternetGateway;
import software.amazon.awssdk.services.ec2.model.InternetGatewayListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInternetGatewaysResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeInternetGatewaysResponse> {
    private final List<InternetGateway> internetGateways;

    private DescribeInternetGatewaysResponse(BuilderImpl builder) {
        this.internetGateways = builder.internetGateways;
    }

    public List<InternetGateway> internetGateways() {
        return this.internetGateways;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.internetGateways());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInternetGatewaysResponse)) {
            return false;
        }
        DescribeInternetGatewaysResponse other = (DescribeInternetGatewaysResponse)((Object)obj);
        return Objects.equals(this.internetGateways(), other.internetGateways());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.internetGateways() != null) {
            sb.append("InternetGateways: ").append(this.internetGateways()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InternetGateways": {
                return Optional.of(clazz.cast(this.internetGateways()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<InternetGateway> internetGateways;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInternetGatewaysResponse model) {
            this.internetGateways(model.internetGateways);
        }

        public final Collection<InternetGateway.Builder> getInternetGateways() {
            return this.internetGateways != null ? (Collection)this.internetGateways.stream().map(InternetGateway::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder internetGateways(Collection<InternetGateway> internetGateways) {
            this.internetGateways = InternetGatewayListCopier.copy(internetGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder internetGateways(InternetGateway ... internetGateways) {
            this.internetGateways(Arrays.asList(internetGateways));
            return this;
        }

        public final void setInternetGateways(Collection<InternetGateway.BuilderImpl> internetGateways) {
            this.internetGateways = InternetGatewayListCopier.copyFromBuilder(internetGateways);
        }

        public DescribeInternetGatewaysResponse build() {
            return new DescribeInternetGatewaysResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeInternetGatewaysResponse> {
        public Builder internetGateways(Collection<InternetGateway> var1);

        public Builder internetGateways(InternetGateway ... var1);
    }
}

