/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.ExecutableByStringListCopier;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.ImageIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.OwnerStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeImagesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeImagesRequest> {
    private final List<String> executableUsers;
    private final List<Filter> filters;
    private final List<String> imageIds;
    private final List<String> owners;

    private DescribeImagesRequest(BuilderImpl builder) {
        this.executableUsers = builder.executableUsers;
        this.filters = builder.filters;
        this.imageIds = builder.imageIds;
        this.owners = builder.owners;
    }

    public List<String> executableUsers() {
        return this.executableUsers;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public List<String> imageIds() {
        return this.imageIds;
    }

    public List<String> owners() {
        return this.owners;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executableUsers());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.owners());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagesRequest)) {
            return false;
        }
        DescribeImagesRequest other = (DescribeImagesRequest)((Object)obj);
        return Objects.equals(this.executableUsers(), other.executableUsers()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.imageIds(), other.imageIds()) && Objects.equals(this.owners(), other.owners());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.executableUsers() != null) {
            sb.append("ExecutableUsers: ").append(this.executableUsers()).append(",");
        }
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.imageIds() != null) {
            sb.append("ImageIds: ").append(this.imageIds()).append(",");
        }
        if (this.owners() != null) {
            sb.append("Owners: ").append(this.owners()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutableUsers": {
                return Optional.of(clazz.cast(this.executableUsers()));
            }
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "ImageIds": {
                return Optional.of(clazz.cast(this.imageIds()));
            }
            case "Owners": {
                return Optional.of(clazz.cast(this.owners()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> executableUsers;
        private List<Filter> filters;
        private List<String> imageIds;
        private List<String> owners;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImagesRequest model) {
            this.executableUsers(model.executableUsers);
            this.filters(model.filters);
            this.imageIds(model.imageIds);
            this.owners(model.owners);
        }

        public final Collection<String> getExecutableUsers() {
            return this.executableUsers;
        }

        @Override
        public final Builder executableUsers(Collection<String> executableUsers) {
            this.executableUsers = ExecutableByStringListCopier.copy(executableUsers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executableUsers(String ... executableUsers) {
            this.executableUsers(Arrays.asList(executableUsers));
            return this;
        }

        public final void setExecutableUsers(Collection<String> executableUsers) {
            this.executableUsers = ExecutableByStringListCopier.copy(executableUsers);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getImageIds() {
            return this.imageIds;
        }

        @Override
        public final Builder imageIds(Collection<String> imageIds) {
            this.imageIds = ImageIdStringListCopier.copy(imageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(String ... imageIds) {
            this.imageIds(Arrays.asList(imageIds));
            return this;
        }

        public final void setImageIds(Collection<String> imageIds) {
            this.imageIds = ImageIdStringListCopier.copy(imageIds);
        }

        public final Collection<String> getOwners() {
            return this.owners;
        }

        @Override
        public final Builder owners(Collection<String> owners) {
            this.owners = OwnerStringListCopier.copy(owners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder owners(String ... owners) {
            this.owners(Arrays.asList(owners));
            return this;
        }

        public final void setOwners(Collection<String> owners) {
            this.owners = OwnerStringListCopier.copy(owners);
        }

        public DescribeImagesRequest build() {
            return new DescribeImagesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeImagesRequest> {
        public Builder executableUsers(Collection<String> var1);

        public Builder executableUsers(String ... var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder imageIds(Collection<String> var1);

        public Builder imageIds(String ... var1);

        public Builder owners(Collection<String> var1);

        public Builder owners(String ... var1);
    }
}

