/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.Address;
import software.amazon.awssdk.services.ec2.model.AddressListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAddressesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeAddressesResponse> {
    private final List<Address> addresses;

    private DescribeAddressesResponse(BuilderImpl builder) {
        this.addresses = builder.addresses;
    }

    public List<Address> addresses() {
        return this.addresses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.addresses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddressesResponse)) {
            return false;
        }
        DescribeAddressesResponse other = (DescribeAddressesResponse)((Object)obj);
        return Objects.equals(this.addresses(), other.addresses());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.addresses() != null) {
            sb.append("Addresses: ").append(this.addresses()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Addresses": {
                return Optional.of(clazz.cast(this.addresses()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Address> addresses;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAddressesResponse model) {
            this.addresses(model.addresses);
        }

        public final Collection<Address.Builder> getAddresses() {
            return this.addresses != null ? (Collection)this.addresses.stream().map(Address::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder addresses(Collection<Address> addresses) {
            this.addresses = AddressListCopier.copy(addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(Address ... addresses) {
            this.addresses(Arrays.asList(addresses));
            return this;
        }

        public final void setAddresses(Collection<Address.BuilderImpl> addresses) {
            this.addresses = AddressListCopier.copyFromBuilder(addresses);
        }

        public DescribeAddressesResponse build() {
            return new DescribeAddressesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAddressesResponse> {
        public Builder addresses(Collection<Address> var1);

        public Builder addresses(Address ... var1);
    }
}

