/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.services.ec2.model.VpcEndpointType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateVpcEndpointRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateVpcEndpointRequest> {
    private final String vpcEndpointType;
    private final String vpcId;
    private final String serviceName;
    private final String policyDocument;
    private final List<String> routeTableIds;
    private final List<String> subnetIds;
    private final List<String> securityGroupIds;
    private final String clientToken;
    private final Boolean privateDnsEnabled;

    private CreateVpcEndpointRequest(BuilderImpl builder) {
        this.vpcEndpointType = builder.vpcEndpointType;
        this.vpcId = builder.vpcId;
        this.serviceName = builder.serviceName;
        this.policyDocument = builder.policyDocument;
        this.routeTableIds = builder.routeTableIds;
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.clientToken = builder.clientToken;
        this.privateDnsEnabled = builder.privateDnsEnabled;
    }

    public VpcEndpointType vpcEndpointType() {
        return VpcEndpointType.fromValue(this.vpcEndpointType);
    }

    public String vpcEndpointTypeString() {
        return this.vpcEndpointType;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String policyDocument() {
        return this.policyDocument;
    }

    public List<String> routeTableIds() {
        return this.routeTableIds;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Boolean privateDnsEnabled() {
        return this.privateDnsEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsEnabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointRequest)) {
            return false;
        }
        CreateVpcEndpointRequest other = (CreateVpcEndpointRequest)((Object)obj);
        return Objects.equals(this.vpcEndpointTypeString(), other.vpcEndpointTypeString()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.policyDocument(), other.policyDocument()) && Objects.equals(this.routeTableIds(), other.routeTableIds()) && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.privateDnsEnabled(), other.privateDnsEnabled());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.vpcEndpointTypeString() != null) {
            sb.append("VpcEndpointType: ").append(this.vpcEndpointTypeString()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (this.serviceName() != null) {
            sb.append("ServiceName: ").append(this.serviceName()).append(",");
        }
        if (this.policyDocument() != null) {
            sb.append("PolicyDocument: ").append(this.policyDocument()).append(",");
        }
        if (this.routeTableIds() != null) {
            sb.append("RouteTableIds: ").append(this.routeTableIds()).append(",");
        }
        if (this.subnetIds() != null) {
            sb.append("SubnetIds: ").append(this.subnetIds()).append(",");
        }
        if (this.securityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.securityGroupIds()).append(",");
        }
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.privateDnsEnabled() != null) {
            sb.append("PrivateDnsEnabled: ").append(this.privateDnsEnabled()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcEndpointType": {
                return Optional.of(clazz.cast(this.vpcEndpointTypeString()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "ServiceName": {
                return Optional.of(clazz.cast(this.serviceName()));
            }
            case "PolicyDocument": {
                return Optional.of(clazz.cast(this.policyDocument()));
            }
            case "RouteTableIds": {
                return Optional.of(clazz.cast(this.routeTableIds()));
            }
            case "SubnetIds": {
                return Optional.of(clazz.cast(this.subnetIds()));
            }
            case "SecurityGroupIds": {
                return Optional.of(clazz.cast(this.securityGroupIds()));
            }
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
            case "PrivateDnsEnabled": {
                return Optional.of(clazz.cast(this.privateDnsEnabled()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String vpcEndpointType;
        private String vpcId;
        private String serviceName;
        private String policyDocument;
        private List<String> routeTableIds;
        private List<String> subnetIds;
        private List<String> securityGroupIds;
        private String clientToken;
        private Boolean privateDnsEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcEndpointRequest model) {
            this.vpcEndpointType(model.vpcEndpointType);
            this.vpcId(model.vpcId);
            this.serviceName(model.serviceName);
            this.policyDocument(model.policyDocument);
            this.routeTableIds(model.routeTableIds);
            this.subnetIds(model.subnetIds);
            this.securityGroupIds(model.securityGroupIds);
            this.clientToken(model.clientToken);
            this.privateDnsEnabled(model.privateDnsEnabled);
        }

        public final String getVpcEndpointType() {
            return this.vpcEndpointType;
        }

        @Override
        public final Builder vpcEndpointType(String vpcEndpointType) {
            this.vpcEndpointType = vpcEndpointType;
            return this;
        }

        @Override
        public final Builder vpcEndpointType(VpcEndpointType vpcEndpointType) {
            this.vpcEndpointType(vpcEndpointType.toString());
            return this;
        }

        public final void setVpcEndpointType(String vpcEndpointType) {
            this.vpcEndpointType = vpcEndpointType;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final Collection<String> getRouteTableIds() {
            return this.routeTableIds;
        }

        @Override
        public final Builder routeTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = ValueStringListCopier.copy(routeTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeTableIds(String ... routeTableIds) {
            this.routeTableIds(Arrays.asList(routeTableIds));
            return this;
        }

        public final void setRouteTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = ValueStringListCopier.copy(routeTableIds);
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = ValueStringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = ValueStringListCopier.copy(subnetIds);
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ValueStringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ValueStringListCopier.copy(securityGroupIds);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Boolean getPrivateDnsEnabled() {
            return this.privateDnsEnabled;
        }

        @Override
        public final Builder privateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        public final void setPrivateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
        }

        public CreateVpcEndpointRequest build() {
            return new CreateVpcEndpointRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateVpcEndpointRequest> {
        public Builder vpcEndpointType(String var1);

        public Builder vpcEndpointType(VpcEndpointType var1);

        public Builder vpcId(String var1);

        public Builder serviceName(String var1);

        public Builder policyDocument(String var1);

        public Builder routeTableIds(Collection<String> var1);

        public Builder routeTableIds(String ... var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder clientToken(String var1);

        public Builder privateDnsEnabled(Boolean var1);
    }
}

