/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.EgressOnlyInternetGateway;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateEgressOnlyInternetGatewayResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CreateEgressOnlyInternetGatewayResponse> {
    private final String clientToken;
    private final EgressOnlyInternetGateway egressOnlyInternetGateway;

    private CreateEgressOnlyInternetGatewayResponse(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.egressOnlyInternetGateway = builder.egressOnlyInternetGateway;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public EgressOnlyInternetGateway egressOnlyInternetGateway() {
        return this.egressOnlyInternetGateway;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.egressOnlyInternetGateway());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEgressOnlyInternetGatewayResponse)) {
            return false;
        }
        CreateEgressOnlyInternetGatewayResponse other = (CreateEgressOnlyInternetGatewayResponse)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.egressOnlyInternetGateway(), other.egressOnlyInternetGateway());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.egressOnlyInternetGateway() != null) {
            sb.append("EgressOnlyInternetGateway: ").append(this.egressOnlyInternetGateway()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
            case "EgressOnlyInternetGateway": {
                return Optional.of(clazz.cast(this.egressOnlyInternetGateway()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String clientToken;
        private EgressOnlyInternetGateway egressOnlyInternetGateway;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEgressOnlyInternetGatewayResponse model) {
            this.clientToken(model.clientToken);
            this.egressOnlyInternetGateway(model.egressOnlyInternetGateway);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final EgressOnlyInternetGateway.Builder getEgressOnlyInternetGateway() {
            return this.egressOnlyInternetGateway != null ? this.egressOnlyInternetGateway.toBuilder() : null;
        }

        @Override
        public final Builder egressOnlyInternetGateway(EgressOnlyInternetGateway egressOnlyInternetGateway) {
            this.egressOnlyInternetGateway = egressOnlyInternetGateway;
            return this;
        }

        public final void setEgressOnlyInternetGateway(EgressOnlyInternetGateway.BuilderImpl egressOnlyInternetGateway) {
            this.egressOnlyInternetGateway = egressOnlyInternetGateway != null ? egressOnlyInternetGateway.build() : null;
        }

        public CreateEgressOnlyInternetGatewayResponse build() {
            return new CreateEgressOnlyInternetGatewayResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateEgressOnlyInternetGatewayResponse> {
        public Builder clientToken(String var1);

        public Builder egressOnlyInternetGateway(EgressOnlyInternetGateway var1);

        default public Builder egressOnlyInternetGateway(Consumer<EgressOnlyInternetGateway.Builder> egressOnlyInternetGateway) {
            return this.egressOnlyInternetGateway((EgressOnlyInternetGateway)((EgressOnlyInternetGateway.Builder)EgressOnlyInternetGateway.builder().apply(egressOnlyInternetGateway)).build());
        }
    }
}

