/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CancelImportTaskResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CancelImportTaskResponse> {
    private final String importTaskId;
    private final String previousState;
    private final String state;

    private CancelImportTaskResponse(BuilderImpl builder) {
        this.importTaskId = builder.importTaskId;
        this.previousState = builder.previousState;
        this.state = builder.state;
    }

    public String importTaskId() {
        return this.importTaskId;
    }

    public String previousState() {
        return this.previousState;
    }

    public String state() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.importTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousState());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelImportTaskResponse)) {
            return false;
        }
        CancelImportTaskResponse other = (CancelImportTaskResponse)((Object)obj);
        return Objects.equals(this.importTaskId(), other.importTaskId()) && Objects.equals(this.previousState(), other.previousState()) && Objects.equals(this.state(), other.state());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.importTaskId() != null) {
            sb.append("ImportTaskId: ").append(this.importTaskId()).append(",");
        }
        if (this.previousState() != null) {
            sb.append("PreviousState: ").append(this.previousState()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImportTaskId": {
                return Optional.of(clazz.cast(this.importTaskId()));
            }
            case "PreviousState": {
                return Optional.of(clazz.cast(this.previousState()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.state()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String importTaskId;
        private String previousState;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelImportTaskResponse model) {
            this.importTaskId(model.importTaskId);
            this.previousState(model.previousState);
            this.state(model.state);
        }

        public final String getImportTaskId() {
            return this.importTaskId;
        }

        @Override
        public final Builder importTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
            return this;
        }

        public final void setImportTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
        }

        public final String getPreviousState() {
            return this.previousState;
        }

        @Override
        public final Builder previousState(String previousState) {
            this.previousState = previousState;
            return this;
        }

        public final void setPreviousState(String previousState) {
            this.previousState = previousState;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public CancelImportTaskResponse build() {
            return new CancelImportTaskResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CancelImportTaskResponse> {
        public Builder importTaskId(String var1);

        public Builder previousState(String var1);

        public Builder state(String var1);
    }
}

