/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociateRouteTableRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AssociateRouteTableRequest> {
    private final String routeTableId;
    private final String subnetId;

    private AssociateRouteTableRequest(BuilderImpl builder) {
        this.routeTableId = builder.routeTableId;
        this.subnetId = builder.subnetId;
    }

    public String routeTableId() {
        return this.routeTableId;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateRouteTableRequest)) {
            return false;
        }
        AssociateRouteTableRequest other = (AssociateRouteTableRequest)((Object)obj);
        return Objects.equals(this.routeTableId(), other.routeTableId()) && Objects.equals(this.subnetId(), other.subnetId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.routeTableId() != null) {
            sb.append("RouteTableId: ").append(this.routeTableId()).append(",");
        }
        if (this.subnetId() != null) {
            sb.append("SubnetId: ").append(this.subnetId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouteTableId": {
                return Optional.of(clazz.cast(this.routeTableId()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String routeTableId;
        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateRouteTableRequest model) {
            this.routeTableId(model.routeTableId);
            this.subnetId(model.subnetId);
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public AssociateRouteTableRequest build() {
            return new AssociateRouteTableRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssociateRouteTableRequest> {
        public Builder routeTableId(String var1);

        public Builder subnetId(String var1);
    }
}

