/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociateDhcpOptionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AssociateDhcpOptionsRequest> {
    private final String dhcpOptionsId;
    private final String vpcId;

    private AssociateDhcpOptionsRequest(BuilderImpl builder) {
        this.dhcpOptionsId = builder.dhcpOptionsId;
        this.vpcId = builder.vpcId;
    }

    public String dhcpOptionsId() {
        return this.dhcpOptionsId;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dhcpOptionsId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateDhcpOptionsRequest)) {
            return false;
        }
        AssociateDhcpOptionsRequest other = (AssociateDhcpOptionsRequest)((Object)obj);
        return Objects.equals(this.dhcpOptionsId(), other.dhcpOptionsId()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dhcpOptionsId() != null) {
            sb.append("DhcpOptionsId: ").append(this.dhcpOptionsId()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DhcpOptionsId": {
                return Optional.of(clazz.cast(this.dhcpOptionsId()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dhcpOptionsId;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateDhcpOptionsRequest model) {
            this.dhcpOptionsId(model.dhcpOptionsId);
            this.vpcId(model.vpcId);
        }

        public final String getDhcpOptionsId() {
            return this.dhcpOptionsId;
        }

        @Override
        public final Builder dhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
            return this;
        }

        public final void setDhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public AssociateDhcpOptionsRequest build() {
            return new AssociateDhcpOptionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssociateDhcpOptionsRequest> {
        public Builder dhcpOptionsId(String var1);

        public Builder vpcId(String var1);
    }
}

