/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.DomainType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AllocateAddressRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AllocateAddressRequest> {
    private final String domain;
    private final String address;

    private AllocateAddressRequest(BuilderImpl builder) {
        this.domain = builder.domain;
        this.address = builder.address;
    }

    public DomainType domain() {
        return DomainType.fromValue(this.domain);
    }

    public String domainString() {
        return this.domain;
    }

    public String address() {
        return this.address;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainString());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateAddressRequest)) {
            return false;
        }
        AllocateAddressRequest other = (AllocateAddressRequest)((Object)obj);
        return Objects.equals(this.domainString(), other.domainString()) && Objects.equals(this.address(), other.address());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainString() != null) {
            sb.append("Domain: ").append(this.domainString()).append(",");
        }
        if (this.address() != null) {
            sb.append("Address: ").append(this.address()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domain": {
                return Optional.of(clazz.cast(this.domainString()));
            }
            case "Address": {
                return Optional.of(clazz.cast(this.address()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String domain;
        private String address;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateAddressRequest model) {
            this.domain(model.domain);
            this.address(model.address);
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(DomainType domain) {
            this.domain(domain.toString());
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getAddress() {
            return this.address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public AllocateAddressRequest build() {
            return new AllocateAddressRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AllocateAddressRequest> {
        public Builder domain(String var1);

        public Builder domain(DomainType var1);

        public Builder address(String var1);
    }
}

