/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.ProvisionedBandwidth;

public class ProvisionedBandwidthUnmarshaller
implements Unmarshaller<ProvisionedBandwidth, StaxUnmarshallerContext> {
    private static final ProvisionedBandwidthUnmarshaller INSTANCE = new ProvisionedBandwidthUnmarshaller();

    public ProvisionedBandwidth unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ProvisionedBandwidth.Builder provisionedBandwidth = ProvisionedBandwidth.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("provisionTime", targetDepth)) {
                    provisionedBandwidth.provisionTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("provisioned", targetDepth)) {
                    provisionedBandwidth.provisioned(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("requestTime", targetDepth)) {
                    provisionedBandwidth.requestTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("requested", targetDepth)) {
                    provisionedBandwidth.requested(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("status", targetDepth)) continue;
                provisionedBandwidth.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ProvisionedBandwidth)provisionedBandwidth.build();
    }

    public static ProvisionedBandwidthUnmarshaller getInstance() {
        return INSTANCE;
    }
}

