/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointRequest;

public class ModifyVpcEndpointRequestMarshaller
implements Marshaller<Request<ModifyVpcEndpointRequest>, ModifyVpcEndpointRequest> {
    public Request<ModifyVpcEndpointRequest> marshall(ModifyVpcEndpointRequest modifyVpcEndpointRequest) {
        List<String> modifyVpcEndpointRequestRemoveRouteTableIdsList;
        if (modifyVpcEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyVpcEndpointRequest, "EC2Client");
        request.addParameter("Action", "ModifyVpcEndpoint");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> modifyVpcEndpointRequestAddRouteTableIdsList = modifyVpcEndpointRequest.addRouteTableIds();
        if (modifyVpcEndpointRequestAddRouteTableIdsList != null) {
            int addRouteTableIdsListIndex = 1;
            for (String modifyVpcEndpointRequestAddRouteTableIdsListValue : modifyVpcEndpointRequestAddRouteTableIdsList) {
                if (modifyVpcEndpointRequestAddRouteTableIdsListValue != null) {
                    request.addParameter("AddRouteTableId." + addRouteTableIdsListIndex, StringUtils.fromString((String)modifyVpcEndpointRequestAddRouteTableIdsListValue));
                }
                ++addRouteTableIdsListIndex;
            }
        }
        if (modifyVpcEndpointRequest.policyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString((String)modifyVpcEndpointRequest.policyDocument()));
        }
        if ((modifyVpcEndpointRequestRemoveRouteTableIdsList = modifyVpcEndpointRequest.removeRouteTableIds()) != null) {
            int removeRouteTableIdsListIndex = 1;
            for (String modifyVpcEndpointRequestRemoveRouteTableIdsListValue : modifyVpcEndpointRequestRemoveRouteTableIdsList) {
                if (modifyVpcEndpointRequestRemoveRouteTableIdsListValue != null) {
                    request.addParameter("RemoveRouteTableId." + removeRouteTableIdsListIndex, StringUtils.fromString((String)modifyVpcEndpointRequestRemoveRouteTableIdsListValue));
                }
                ++removeRouteTableIdsListIndex;
            }
        }
        if (modifyVpcEndpointRequest.resetPolicy() != null) {
            request.addParameter("ResetPolicy", StringUtils.fromBoolean((Boolean)modifyVpcEndpointRequest.resetPolicy()));
        }
        if (modifyVpcEndpointRequest.vpcEndpointId() != null) {
            request.addParameter("VpcEndpointId", StringUtils.fromString((String)modifyVpcEndpointRequest.vpcEndpointId()));
        }
        return request;
    }
}

