/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeVpcEndpointsRequestMarshaller
implements Marshaller<Request<DescribeVpcEndpointsRequest>, DescribeVpcEndpointsRequest> {
    public Request<DescribeVpcEndpointsRequest> marshall(DescribeVpcEndpointsRequest describeVpcEndpointsRequest) {
        List<String> describeVpcEndpointsRequestVpcEndpointIdsList;
        if (describeVpcEndpointsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVpcEndpointsRequest, "EC2Client");
        request.addParameter("Action", "DescribeVpcEndpoints");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeVpcEndpointsRequestFiltersList = describeVpcEndpointsRequest.filters();
        if (describeVpcEndpointsRequestFiltersList != null) {
            int filtersListIndex = 1;
            for (Filter describeVpcEndpointsRequestFiltersListValue : describeVpcEndpointsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeVpcEndpointsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeVpcEndpointsRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeVpcEndpointsRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeVpcEndpointsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeVpcEndpointsRequest.maxResults()));
        }
        if (describeVpcEndpointsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeVpcEndpointsRequest.nextToken()));
        }
        if ((describeVpcEndpointsRequestVpcEndpointIdsList = describeVpcEndpointsRequest.vpcEndpointIds()) != null) {
            int vpcEndpointIdsListIndex = 1;
            for (String describeVpcEndpointsRequestVpcEndpointIdsListValue : describeVpcEndpointsRequestVpcEndpointIdsList) {
                if (describeVpcEndpointsRequestVpcEndpointIdsListValue != null) {
                    request.addParameter("VpcEndpointId." + vpcEndpointIdsListIndex, StringUtils.fromString((String)describeVpcEndpointsRequestVpcEndpointIdsListValue));
                }
                ++vpcEndpointIdsListIndex;
            }
        }
        return request;
    }
}

