/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeSpotPriceHistoryRequestMarshaller
implements Marshaller<Request<DescribeSpotPriceHistoryRequest>, DescribeSpotPriceHistoryRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<DescribeSpotPriceHistoryRequest> marshall(DescribeSpotPriceHistoryRequest describeSpotPriceHistoryRequest) {
        List<String> describeSpotPriceHistoryRequestProductDescriptionsList;
        List<String> describeSpotPriceHistoryRequestInstanceTypesList;
        if (describeSpotPriceHistoryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSpotPriceHistoryRequest, "EC2Client");
        request.addParameter("Action", "DescribeSpotPriceHistory");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeSpotPriceHistoryRequestFiltersList = describeSpotPriceHistoryRequest.filters();
        if (describeSpotPriceHistoryRequestFiltersList != null) {
            int filtersListIndex = 1;
            for (Filter filter : describeSpotPriceHistoryRequestFiltersList) {
                List<String> filterValuesList;
                if (filter.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filter.name()));
                }
                if ((filterValuesList = filter.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeSpotPriceHistoryRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)describeSpotPriceHistoryRequest.availabilityZone()));
        }
        if (describeSpotPriceHistoryRequest.endTime() != null) {
            request.addParameter("EndTime", StringUtils.fromInstant((Instant)describeSpotPriceHistoryRequest.endTime()));
        }
        if ((describeSpotPriceHistoryRequestInstanceTypesList = describeSpotPriceHistoryRequest.instanceTypesStrings()) != null) {
            int instanceTypesListIndex = 1;
            for (String describeSpotPriceHistoryRequestInstanceTypesListValue : describeSpotPriceHistoryRequestInstanceTypesList) {
                if (describeSpotPriceHistoryRequestInstanceTypesListValue != null) {
                    request.addParameter("InstanceType." + instanceTypesListIndex, StringUtils.fromString((String)describeSpotPriceHistoryRequestInstanceTypesListValue));
                }
                ++instanceTypesListIndex;
            }
        }
        if (describeSpotPriceHistoryRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeSpotPriceHistoryRequest.maxResults()));
        }
        if (describeSpotPriceHistoryRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeSpotPriceHistoryRequest.nextToken()));
        }
        if ((describeSpotPriceHistoryRequestProductDescriptionsList = describeSpotPriceHistoryRequest.productDescriptions()) != null) {
            boolean bl = true;
            for (String describeSpotPriceHistoryRequestProductDescriptionsListValue : describeSpotPriceHistoryRequestProductDescriptionsList) {
                void var6_12;
                if (describeSpotPriceHistoryRequestProductDescriptionsListValue != null) {
                    request.addParameter("ProductDescription." + (int)var6_12, StringUtils.fromString((String)describeSpotPriceHistoryRequestProductDescriptionsListValue));
                }
                ++var6_12;
            }
        }
        if (describeSpotPriceHistoryRequest.startTime() != null) {
            request.addParameter("StartTime", StringUtils.fromInstant((Instant)describeSpotPriceHistoryRequest.startTime()));
        }
        return request;
    }
}

